/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.config.DefaultHoodieConfig;

public class ConsistencyGuardConfig
extends DefaultHoodieConfig {
    private static final String CONSISTENCY_CHECK_ENABLED_PROP = "hoodie.consistency.check.enabled";
    private static final String DEFAULT_CONSISTENCY_CHECK_ENABLED = "false";
    private static final String INITIAL_CONSISTENCY_CHECK_INTERVAL_MS_PROP = "hoodie.consistency.check.initial_interval_ms";
    private static long DEFAULT_INITIAL_CONSISTENCY_CHECK_INTERVAL_MS = 2000L;
    private static final String MAX_CONSISTENCY_CHECK_INTERVAL_MS_PROP = "hoodie.consistency.check.max_interval_ms";
    private static long DEFAULT_MAX_CONSISTENCY_CHECK_INTERVAL_MS = 300000L;
    private static final String MAX_CONSISTENCY_CHECKS_PROP = "hoodie.consistency.check.max_checks";
    private static int DEFAULT_MAX_CONSISTENCY_CHECKS = 7;

    public ConsistencyGuardConfig(Properties props) {
        super(props);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean isConsistencyCheckEnabled() {
        return Boolean.parseBoolean(this.props.getProperty(CONSISTENCY_CHECK_ENABLED_PROP));
    }

    public int getMaxConsistencyChecks() {
        return Integer.parseInt(this.props.getProperty(MAX_CONSISTENCY_CHECKS_PROP));
    }

    public int getInitialConsistencyCheckIntervalMs() {
        return Integer.parseInt(this.props.getProperty(INITIAL_CONSISTENCY_CHECK_INTERVAL_MS_PROP));
    }

    public int getMaxConsistencyCheckIntervalMs() {
        return Integer.parseInt(this.props.getProperty(MAX_CONSISTENCY_CHECK_INTERVAL_MS_PROP));
    }

    public static class Builder {
        private final Properties props = new Properties();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.props.load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.props.putAll((Map<?, ?>)props);
            return this;
        }

        public Builder withConsistencyCheckEnabled(boolean enabled) {
            this.props.setProperty(ConsistencyGuardConfig.CONSISTENCY_CHECK_ENABLED_PROP, String.valueOf(enabled));
            return this;
        }

        public Builder withInitialConsistencyCheckIntervalMs(int initialIntevalMs) {
            this.props.setProperty(ConsistencyGuardConfig.INITIAL_CONSISTENCY_CHECK_INTERVAL_MS_PROP, String.valueOf(initialIntevalMs));
            return this;
        }

        public Builder withMaxConsistencyCheckIntervalMs(int maxIntervalMs) {
            this.props.setProperty(ConsistencyGuardConfig.MAX_CONSISTENCY_CHECK_INTERVAL_MS_PROP, String.valueOf(maxIntervalMs));
            return this;
        }

        public Builder withMaxConsistencyChecks(int maxConsistencyChecks) {
            this.props.setProperty(ConsistencyGuardConfig.MAX_CONSISTENCY_CHECKS_PROP, String.valueOf(maxConsistencyChecks));
            return this;
        }

        public ConsistencyGuardConfig build() {
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(ConsistencyGuardConfig.CONSISTENCY_CHECK_ENABLED_PROP), ConsistencyGuardConfig.CONSISTENCY_CHECK_ENABLED_PROP, ConsistencyGuardConfig.DEFAULT_CONSISTENCY_CHECK_ENABLED);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(ConsistencyGuardConfig.INITIAL_CONSISTENCY_CHECK_INTERVAL_MS_PROP), ConsistencyGuardConfig.INITIAL_CONSISTENCY_CHECK_INTERVAL_MS_PROP, String.valueOf(DEFAULT_INITIAL_CONSISTENCY_CHECK_INTERVAL_MS));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(ConsistencyGuardConfig.MAX_CONSISTENCY_CHECK_INTERVAL_MS_PROP), ConsistencyGuardConfig.MAX_CONSISTENCY_CHECK_INTERVAL_MS_PROP, String.valueOf(DEFAULT_MAX_CONSISTENCY_CHECK_INTERVAL_MS));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(ConsistencyGuardConfig.MAX_CONSISTENCY_CHECKS_PROP), ConsistencyGuardConfig.MAX_CONSISTENCY_CHECKS_PROP, String.valueOf(DEFAULT_MAX_CONSISTENCY_CHECKS));
            return new ConsistencyGuardConfig(this.props);
        }
    }
}

