/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.exception;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;

public class DatasetNotFoundException
extends HoodieException {
    public DatasetNotFoundException(String basePath) {
        super(DatasetNotFoundException.getErrorMessage(basePath));
    }

    private static String getErrorMessage(String basePath) {
        return "Hoodie dataset not found in path " + basePath;
    }

    public static void checkValidDataset(FileSystem fs, Path basePathDir, Path metaPathDir) throws DatasetNotFoundException {
        try {
            if (!fs.exists(basePathDir) || !fs.isDirectory(basePathDir)) {
                throw new DatasetNotFoundException(basePathDir.toString());
            }
            if (!fs.exists(metaPathDir) || !fs.isDirectory(metaPathDir)) {
                throw new DatasetNotFoundException(metaPathDir.toString());
            }
        }
        catch (IllegalArgumentException e) {
            throw new DatasetNotFoundException(metaPathDir.toString());
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not check if dataset " + basePathDir + " is valid dataset", e);
        }
    }
}

