/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieHiveUtil {
    public static final Logger LOG = LogManager.getLogger(HoodieHiveUtil.class);
    public static final String HOODIE_CONSUME_MODE_PATTERN = "hoodie.%s.consume.mode";
    public static final String HOODIE_START_COMMIT_PATTERN = "hoodie.%s.consume.start.timestamp";
    public static final String HOODIE_MAX_COMMIT_PATTERN = "hoodie.%s.consume.max.commits";
    public static final String INCREMENTAL_SCAN_MODE = "INCREMENTAL";
    public static final String LATEST_SCAN_MODE = "LATEST";
    public static final String DEFAULT_SCAN_MODE = "LATEST";
    public static final int DEFAULT_MAX_COMMITS = 1;
    public static final int MAX_COMMIT_ALL = -1;
    public static final int DEFAULT_LEVELS_TO_BASEPATH = 3;

    public static Integer readMaxCommits(JobContext job, String tableName) {
        String maxCommitName = String.format(HOODIE_MAX_COMMIT_PATTERN, tableName);
        int maxCommits = job.getConfiguration().getInt(maxCommitName, 1);
        if (maxCommits == -1) {
            maxCommits = Integer.MAX_VALUE;
        }
        LOG.info((Object)("Read max commits - " + maxCommits));
        return maxCommits;
    }

    public static String readStartCommitTime(JobContext job, String tableName) {
        String startCommitTimestampName = String.format(HOODIE_START_COMMIT_PATTERN, tableName);
        LOG.info((Object)("Read start commit time - " + job.getConfiguration().get(startCommitTimestampName)));
        return job.getConfiguration().get(startCommitTimestampName);
    }

    public static String readMode(JobContext job, String tableName) {
        String modePropertyName = String.format(HOODIE_CONSUME_MODE_PATTERN, tableName);
        String mode = job.getConfiguration().get(modePropertyName, "LATEST");
        LOG.info((Object)(modePropertyName + ": " + mode));
        return mode;
    }

    public static Path getNthParent(Path path, int n) {
        Path parent = path;
        for (int i = 0; i < n; ++i) {
            parent = parent.getParent();
        }
        return parent;
    }
}

