/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hudi.common.model.HoodieDataFile;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.exception.DatasetNotFoundException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.InvalidDatasetException;
import org.apache.hudi.hadoop.HoodieHiveUtil;
import org.apache.hudi.hadoop.UseFileSplitsFromInputFormat;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@UseFileSplitsFromInputFormat
public class HoodieParquetInputFormat
extends MapredParquetInputFormat
implements Configurable {
    private static final transient Logger LOG = LogManager.getLogger(HoodieParquetInputFormat.class);
    protected Configuration conf;

    public FileStatus[] listStatus(JobConf job) throws IOException {
        FileStatus[] fileStatuses = super.listStatus(job);
        Map<HoodieTableMetaClient, List<FileStatus>> groupedFileStatus = this.groupFileStatus(fileStatuses);
        LOG.info((Object)("Found a total of " + groupedFileStatus.size() + " groups"));
        ArrayList<FileStatus> returns = new ArrayList<FileStatus>();
        for (Map.Entry<HoodieTableMetaClient, List<FileStatus>> entry : groupedFileStatus.entrySet()) {
            HoodieTableMetaClient metadata = entry.getKey();
            if (metadata == null) {
                returns.addAll((Collection)entry.getValue());
                continue;
            }
            FileStatus[] statuses = entry.getValue().toArray(new FileStatus[entry.getValue().size()]);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Hoodie Metadata initialized with completed commit Ts as :" + metadata));
            }
            String tableName = metadata.getTableConfig().getTableName();
            String mode = HoodieHiveUtil.readMode((JobContext)Job.getInstance((Configuration)job), tableName);
            HoodieTimeline timeline = metadata.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
            HoodieTableFileSystemView roView = new HoodieTableFileSystemView(metadata, timeline, statuses);
            if ("INCREMENTAL".equals(mode)) {
                String lastIncrementalTs = HoodieHiveUtil.readStartCommitTime((JobContext)Job.getInstance((Configuration)job), tableName);
                Integer maxCommits = HoodieHiveUtil.readMaxCommits((JobContext)Job.getInstance((Configuration)job), tableName);
                LOG.info((Object)("Last Incremental timestamp was set as " + lastIncrementalTs));
                List<String> commitsToReturn = timeline.findInstantsAfter(lastIncrementalTs, maxCommits).getInstants().map(HoodieInstant::getTimestamp).collect(Collectors.toList());
                List filteredFiles = roView.getLatestDataFilesInRange(commitsToReturn).collect(Collectors.toList());
                for (HoodieDataFile filteredFile : filteredFiles) {
                    LOG.info((Object)("Processing incremental hoodie file - " + filteredFile.getPath()));
                    filteredFile = this.checkFileStatus(filteredFile);
                    returns.add(filteredFile.getFileStatus());
                }
                LOG.info((Object)("Total paths to process after hoodie incremental filter " + filteredFiles.size()));
                continue;
            }
            List filteredFiles = roView.getLatestDataFiles().collect(Collectors.toList());
            LOG.info((Object)("Total paths to process after hoodie filter " + filteredFiles.size()));
            for (HoodieDataFile filteredFile : filteredFiles) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Processing latest hoodie file - " + filteredFile.getPath()));
                }
                filteredFile = this.checkFileStatus(filteredFile);
                returns.add(filteredFile.getFileStatus());
            }
        }
        return returns.toArray(new FileStatus[returns.size()]);
    }

    private HoodieDataFile checkFileStatus(HoodieDataFile dataFile) throws IOException {
        Path dataPath = dataFile.getFileStatus().getPath();
        try {
            if (dataFile.getFileSize() == 0L) {
                FileSystem fs = dataPath.getFileSystem(this.conf);
                LOG.info((Object)("Refreshing file status " + dataFile.getPath()));
                return new HoodieDataFile(fs.getFileStatus(dataPath));
            }
            return dataFile;
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not get FileStatus on path " + dataPath);
        }
    }

    private Map<HoodieTableMetaClient, List<FileStatus>> groupFileStatus(FileStatus[] fileStatuses) throws IOException {
        HashMap<HoodieTableMetaClient, List<FileStatus>> grouped = new HashMap<HoodieTableMetaClient, List<FileStatus>>();
        HoodieTableMetaClient metadata = null;
        String nonHoodieBasePath = null;
        for (FileStatus status : fileStatuses) {
            if (!status.getPath().getName().endsWith(".parquet")) continue;
            if (metadata == null && nonHoodieBasePath == null || metadata == null && !status.getPath().toString().contains(nonHoodieBasePath) || metadata != null && !status.getPath().toString().contains(metadata.getBasePath())) {
                try {
                    metadata = HoodieParquetInputFormat.getTableMetaClient(status.getPath().getFileSystem(this.conf), status.getPath().getParent());
                    nonHoodieBasePath = null;
                }
                catch (DatasetNotFoundException | InvalidDatasetException e) {
                    LOG.info((Object)("Handling a non-hoodie path " + status.getPath()));
                    metadata = null;
                    nonHoodieBasePath = status.getPath().getParent().toString();
                }
                if (!grouped.containsKey(metadata)) {
                    grouped.put(metadata, new ArrayList());
                }
            }
            ((List)grouped.get(metadata)).add(status);
        }
        return grouped;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public RecordReader<NullWritable, ArrayWritable> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        return super.getRecordReader(split, job, reporter);
    }

    protected static HoodieTableMetaClient getTableMetaClient(FileSystem fs, Path dataPath) throws IOException {
        int levels = 3;
        if (HoodiePartitionMetadata.hasPartitionMetadata(fs, dataPath)) {
            HoodiePartitionMetadata metadata = new HoodiePartitionMetadata(fs, dataPath);
            metadata.readFromFS();
            levels = metadata.getPartitionDepth();
        }
        Path baseDir = HoodieHiveUtil.getNthParent(dataPath, levels);
        LOG.info((Object)("Reading hoodie metadata from path " + baseDir.toString()));
        return new HoodieTableMetaClient(fs.getConf(), baseDir.toString());
    }
}

