/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hudi.exception.HoodieException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class RecordReaderValueIterator<K, V>
implements Iterator<V> {
    private static final transient Logger LOG = LogManager.getLogger(RecordReaderValueIterator.class);
    private final RecordReader<K, V> reader;
    private V nextVal = null;

    public RecordReaderValueIterator(RecordReader<K, V> reader) {
        this.reader = reader;
    }

    @Override
    public boolean hasNext() {
        if (this.nextVal == null) {
            Object key = this.reader.createKey();
            Object val = this.reader.createValue();
            try {
                boolean notDone = this.reader.next(key, val);
                if (!notDone) {
                    return false;
                }
                this.nextVal = val;
            }
            catch (IOException e) {
                LOG.error((Object)"Got error reading next record from record reader");
                throw new HoodieException(e);
            }
        }
        return true;
    }

    @Override
    public V next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Make sure you are following iterator contract.");
        }
        V retVal = this.nextVal;
        this.nextVal = null;
        return retVal;
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

