/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.util.List;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.log.AbstractHoodieLogRecordScanner;
import org.apache.hudi.org.apache.avro.Schema;

public class HoodieUnMergedLogRecordScanner
extends AbstractHoodieLogRecordScanner {
    private final LogRecordScannerCallback callback;

    public HoodieUnMergedLogRecordScanner(FileSystem fs, String basePath, List<String> logFilePaths, Schema readerSchema, String latestInstantTime, boolean readBlocksLazily, boolean reverseReader, int bufferSize, LogRecordScannerCallback callback) {
        super(fs, basePath, logFilePaths, readerSchema, latestInstantTime, readBlocksLazily, reverseReader, bufferSize);
        this.callback = callback;
    }

    @Override
    protected void processNextRecord(HoodieRecord<? extends HoodieRecordPayload> hoodieRecord) throws Exception {
        this.callback.apply(hoodieRecord);
    }

    @Override
    protected void processNextDeletedKey(HoodieKey key) {
        throw new IllegalStateException("Not expected to see delete records in this log-scan mode. Check Job Config");
    }

    @FunctionalInterface
    public static interface LogRecordScannerCallback {
        public void apply(HoodieRecord<? extends HoodieRecordPayload> var1) throws Exception;
    }
}

