/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTimeline;
import org.apache.hudi.common.table.timeline.HoodieDefaultTimeline;
import org.apache.hudi.common.table.timeline.dto.InstantDTO;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TimelineDTO {
    @JsonProperty(value="instants")
    List<InstantDTO> instants;

    public static TimelineDTO fromTimeline(HoodieTimeline timeline) {
        TimelineDTO dto = new TimelineDTO();
        dto.instants = timeline.getInstants().map(InstantDTO::fromInstant).collect(Collectors.toList());
        return dto;
    }

    public static HoodieTimeline toTimeline(TimelineDTO dto, HoodieTableMetaClient metaClient) {
        return new HoodieDefaultTimeline(dto.instants.stream().map(InstantDTO::toInstant), metaClient.getActiveTimeline()::getInstantDetails);
    }
}

