/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.view;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTimeline;
import org.apache.hudi.common.table.SyncableFileSystemView;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.FSUtils;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class AbstractTableFileSystemView
implements SyncableFileSystemView,
Serializable {
    private static final Logger LOG = LogManager.getLogger(AbstractTableFileSystemView.class);
    protected HoodieTableMetaClient metaClient;
    private HoodieTimeline visibleCommitsAndCompactionTimeline;
    private ConcurrentHashMap<String, Boolean> addedPartitions = new ConcurrentHashMap(4096);
    private final ReentrantReadWriteLock globalLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.globalLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.globalLock.writeLock();

    private String getPartitionPathFromFilePath(String fullPath) {
        return FSUtils.getRelativePartitionPath(new Path(this.metaClient.getBasePath()), new Path(fullPath).getParent());
    }

    protected void init(HoodieTableMetaClient metaClient, HoodieTimeline visibleActiveTimeline) {
        this.metaClient = metaClient;
        this.refreshTimeline(visibleActiveTimeline);
        this.resetPendingCompactionOperations(CompactionUtils.getAllPendingCompactionOperations(metaClient).values().stream().map(e -> Pair.of(e.getKey(), CompactionOperation.convertFromAvroRecordInstance((HoodieCompactionOperation)e.getValue()))));
    }

    protected void refreshTimeline(HoodieTimeline visibleActiveTimeline) {
        this.visibleCommitsAndCompactionTimeline = visibleActiveTimeline.getCommitsAndCompactionTimeline();
    }

    protected List<HoodieFileGroup> addFilesToView(FileStatus[] statuses) {
        HoodieTimer timer = new HoodieTimer().startTimer();
        List<HoodieFileGroup> fileGroups = this.buildFileGroups(statuses, this.visibleCommitsAndCompactionTimeline, true);
        long fgBuildTimeTakenMs = timer.endTimer();
        timer.startTimer();
        fileGroups.stream().collect(Collectors.groupingBy(HoodieFileGroup::getPartitionPath)).entrySet().forEach(entry -> {
            String partition = (String)entry.getKey();
            if (!this.isPartitionAvailableInStore(partition)) {
                this.storePartitionView(partition, (List)entry.getValue());
            }
        });
        long storePartitionsTs = timer.endTimer();
        LOG.info((Object)("addFilesToView: NumFiles=" + statuses.length + ", FileGroupsCreationTime=" + fgBuildTimeTakenMs + ", StoreTimeTaken=" + storePartitionsTs));
        return fileGroups;
    }

    protected List<HoodieFileGroup> buildFileGroups(FileStatus[] statuses, HoodieTimeline timeline, boolean addPendingCompactionFileSlice) {
        return this.buildFileGroups(this.convertFileStatusesToBaseFiles(statuses), this.convertFileStatusesToLogFiles(statuses), timeline, addPendingCompactionFileSlice);
    }

    protected List<HoodieFileGroup> buildFileGroups(Stream<HoodieBaseFile> baseFileStream, Stream<HoodieLogFile> logFileStream, HoodieTimeline timeline, boolean addPendingCompactionFileSlice) {
        Map<Pair, List<HoodieBaseFile>> baseFiles = baseFileStream.collect(Collectors.groupingBy(baseFile -> {
            String partitionPathStr = this.getPartitionPathFromFilePath(baseFile.getPath());
            return Pair.of(partitionPathStr, baseFile.getFileId());
        }));
        Map<Pair, List<HoodieLogFile>> logFiles = logFileStream.collect(Collectors.groupingBy(logFile -> {
            String partitionPathStr = FSUtils.getRelativePartitionPath(new Path(this.metaClient.getBasePath()), logFile.getPath().getParent());
            return Pair.of(partitionPathStr, logFile.getFileId());
        }));
        HashSet<Pair> fileIdSet = new HashSet<Pair>(baseFiles.keySet());
        fileIdSet.addAll(logFiles.keySet());
        ArrayList<HoodieFileGroup> fileGroups = new ArrayList<HoodieFileGroup>();
        fileIdSet.forEach(pair -> {
            Option<Pair<String, CompactionOperation>> pendingCompaction;
            String fileId = (String)pair.getValue();
            HoodieFileGroup group = new HoodieFileGroup((String)pair.getKey(), fileId, timeline);
            if (baseFiles.containsKey(pair)) {
                ((List)baseFiles.get(pair)).forEach(group::addBaseFile);
            }
            if (logFiles.containsKey(pair)) {
                ((List)logFiles.get(pair)).forEach(group::addLogFile);
            }
            if (addPendingCompactionFileSlice && (pendingCompaction = this.getPendingCompactionOperationWithInstant(group.getFileGroupId())).isPresent()) {
                group.addNewFileSliceAtInstant(pendingCompaction.get().getKey());
            }
            fileGroups.add(group);
        });
        return fileGroups;
    }

    @Override
    public final void reset() {
        try {
            this.writeLock.lock();
            this.addedPartitions.clear();
            this.resetViewState();
            this.init(this.metaClient, this.getTimeline());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected abstract void resetViewState();

    private void ensurePartitionLoadedCorrectly(String partition) {
        Preconditions.checkArgument((!this.isClosed() ? 1 : 0) != 0, (Object)"View is already closed");
        this.addedPartitions.computeIfAbsent(partition, this::lambda$ensurePartitionLoadedCorrectly$5);
    }

    private Stream<HoodieBaseFile> convertFileStatusesToBaseFiles(FileStatus[] statuses) {
        Predicate<FileStatus> roFilePredicate = fileStatus -> fileStatus.getPath().getName().contains(this.metaClient.getTableConfig().getBaseFileFormat().getFileExtension());
        return Arrays.stream(statuses).filter(roFilePredicate).map(HoodieBaseFile::new);
    }

    private Stream<HoodieLogFile> convertFileStatusesToLogFiles(FileStatus[] statuses) {
        Predicate<FileStatus> rtFilePredicate = fileStatus -> fileStatus.getPath().getName().contains(this.metaClient.getTableConfig().getLogFileFormat().getFileExtension());
        return Arrays.stream(statuses).filter(rtFilePredicate).map(HoodieLogFile::new);
    }

    protected boolean isBaseFileDueToPendingCompaction(HoodieBaseFile baseFile) {
        String partitionPath = this.getPartitionPathFromFilePath(baseFile.getPath());
        Option<Pair<String, CompactionOperation>> compactionWithInstantTime = this.getPendingCompactionOperationWithInstant(new HoodieFileGroupId(partitionPath, baseFile.getFileId()));
        return compactionWithInstantTime.isPresent() && null != compactionWithInstantTime.get().getKey() && baseFile.getCommitTime().equals(compactionWithInstantTime.get().getKey());
    }

    protected boolean isFileSliceAfterPendingCompaction(FileSlice fileSlice) {
        Option<Pair<String, CompactionOperation>> compactionWithInstantTime = this.getPendingCompactionOperationWithInstant(fileSlice.getFileGroupId());
        LOG.info((Object)("Pending Compaction instant for (" + fileSlice + ") is :" + compactionWithInstantTime));
        return compactionWithInstantTime.isPresent() && fileSlice.getBaseInstantTime().equals(compactionWithInstantTime.get().getKey());
    }

    protected FileSlice filterBaseFileAfterPendingCompaction(FileSlice fileSlice) {
        if (this.isFileSliceAfterPendingCompaction(fileSlice)) {
            LOG.info((Object)("File Slice (" + fileSlice + ") is in pending compaction"));
            FileSlice transformed = new FileSlice(fileSlice.getPartitionPath(), fileSlice.getBaseInstantTime(), fileSlice.getFileId());
            fileSlice.getLogFiles().forEach(transformed::addLogFile);
            return transformed;
        }
        return fileSlice;
    }

    @Override
    public final Stream<Pair<String, CompactionOperation>> getPendingCompactionOperations() {
        try {
            this.readLock.lock();
            Stream<Pair<String, CompactionOperation>> stream = this.fetchPendingCompactionOperations();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Stream<HoodieBaseFile> getLatestBaseFiles(String partitionStr) {
        try {
            this.readLock.lock();
            String partitionPath = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partitionPath);
            Stream<HoodieBaseFile> stream = this.fetchLatestBaseFiles(partitionPath);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public final Stream<HoodieBaseFile> getLatestBaseFiles() {
        try {
            this.readLock.lock();
            Stream<HoodieBaseFile> stream = this.fetchLatestBaseFiles();
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Stream<HoodieBaseFile> getLatestBaseFilesBeforeOrOn(String partitionStr, String maxCommitTime) {
        try {
            this.readLock.lock();
            String partitionPath = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partitionPath);
            Stream<HoodieBaseFile> stream = this.fetchAllStoredFileGroups(partitionPath).map(fileGroup -> Option.fromJavaOptional(fileGroup.getAllBaseFiles().filter(baseFile -> HoodieTimeline.compareTimestamps(baseFile.getCommitTime(), maxCommitTime, HoodieTimeline.LESSER_OR_EQUAL)).filter(df -> !this.isBaseFileDueToPendingCompaction((HoodieBaseFile)df)).findFirst())).filter(Option::isPresent).map(Option::get);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Option<HoodieBaseFile> getBaseFileOn(String partitionStr, String instantTime, String fileId) {
        try {
            this.readLock.lock();
            String partitionPath = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partitionPath);
            Option<HoodieBaseFile> option = this.fetchHoodieFileGroup(partitionPath, fileId).map(fileGroup -> fileGroup.getAllBaseFiles().filter(baseFile -> HoodieTimeline.compareTimestamps(baseFile.getCommitTime(), instantTime, HoodieTimeline.EQUAL)).filter(df -> !this.isBaseFileDueToPendingCompaction((HoodieBaseFile)df)).findFirst().orElse(null));
            return option;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Option<HoodieBaseFile> getLatestBaseFile(String partitionStr, String fileId) {
        try {
            this.readLock.lock();
            String partitionPath = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partitionPath);
            Option<HoodieBaseFile> option = this.fetchLatestBaseFile(partitionPath, fileId);
            return option;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public final Stream<HoodieBaseFile> getLatestBaseFilesInRange(List<String> commitsToReturn) {
        try {
            this.readLock.lock();
            Stream<HoodieBaseFile> stream = this.fetchAllStoredFileGroups().map(fileGroup -> Option.fromJavaOptional(fileGroup.getAllBaseFiles().filter(baseFile -> commitsToReturn.contains(baseFile.getCommitTime()) && !this.isBaseFileDueToPendingCompaction((HoodieBaseFile)baseFile)).findFirst())).filter(Option::isPresent).map(Option::get);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Stream<HoodieBaseFile> getAllBaseFiles(String partitionStr) {
        try {
            this.readLock.lock();
            String partitionPath = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partitionPath);
            Stream<HoodieBaseFile> stream = this.fetchAllBaseFiles(partitionPath).filter(df -> this.visibleCommitsAndCompactionTimeline.containsOrBeforeTimelineStarts(df.getCommitTime())).filter(df -> !this.isBaseFileDueToPendingCompaction((HoodieBaseFile)df));
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Stream<FileSlice> getLatestFileSlices(String partitionStr) {
        try {
            this.readLock.lock();
            String partitionPath = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partitionPath);
            Stream<FileSlice> stream = this.fetchLatestFileSlices(partitionPath).map(this::filterBaseFileAfterPendingCompaction);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Option<FileSlice> getLatestFileSlice(String partitionStr, String fileId) {
        try {
            this.readLock.lock();
            String partitionPath = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partitionPath);
            Option<FileSlice> fs = this.fetchLatestFileSlice(partitionPath, fileId);
            Option<FileSlice> option = fs.map(f -> this.filterBaseFileAfterPendingCompaction((FileSlice)f));
            return option;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Stream<FileSlice> getLatestUnCompactedFileSlices(String partitionStr) {
        try {
            this.readLock.lock();
            String partitionPath = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partitionPath);
            Stream<FileSlice> stream = this.fetchAllStoredFileGroups(partitionPath).map(fileGroup -> {
                FileSlice fileSlice = fileGroup.getLatestFileSlice().get();
                Option<Pair<String, CompactionOperation>> compactionWithInstantPair = this.getPendingCompactionOperationWithInstant(fileSlice.getFileGroupId());
                if (compactionWithInstantPair.isPresent()) {
                    String compactionInstantTime = compactionWithInstantPair.get().getLeft();
                    return fileGroup.getLatestFileSliceBefore(compactionInstantTime);
                }
                return Option.of(fileSlice);
            }).map(Option::get);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Stream<FileSlice> getLatestFileSlicesBeforeOrOn(String partitionStr, String maxCommitTime, boolean includeFileSlicesInPendingCompaction) {
        try {
            this.readLock.lock();
            String partitionPath = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partitionPath);
            Stream<FileSlice> fileSliceStream = this.fetchLatestFileSlicesBeforeOrOn(partitionPath, maxCommitTime);
            if (includeFileSlicesInPendingCompaction) {
                Stream<FileSlice> stream = fileSliceStream.map(fs -> this.filterBaseFileAfterPendingCompaction((FileSlice)fs));
                return stream;
            }
            Stream<FileSlice> stream = fileSliceStream.filter(fs -> !this.isPendingCompactionScheduledForFileId(fs.getFileGroupId()));
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Stream<FileSlice> getLatestMergedFileSlicesBeforeOrOn(String partitionStr, String maxInstantTime) {
        try {
            this.readLock.lock();
            String partition = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partition);
            Stream<FileSlice> stream = this.fetchAllStoredFileGroups(partition).map(fileGroup -> {
                Option<FileSlice> fileSlice = fileGroup.getLatestFileSliceBeforeOrOn(maxInstantTime);
                if (fileSlice.isPresent()) {
                    fileSlice = Option.of(this.fetchMergedFileSlice((HoodieFileGroup)fileGroup, fileSlice.get()));
                }
                return fileSlice;
            }).filter(Option::isPresent).map(Option::get);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public final Stream<FileSlice> getLatestFileSliceInRange(List<String> commitsToReturn) {
        try {
            this.readLock.lock();
            Stream<FileSlice> stream = this.fetchLatestFileSliceInRange(commitsToReturn);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Stream<FileSlice> getAllFileSlices(String partitionStr) {
        try {
            this.readLock.lock();
            String partition = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partition);
            Stream<FileSlice> stream = this.fetchAllFileSlices(partition);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private String formatPartitionKey(String partitionStr) {
        return partitionStr.endsWith("/") ? partitionStr.substring(0, partitionStr.length() - 1) : partitionStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Stream<HoodieFileGroup> getAllFileGroups(String partitionStr) {
        try {
            this.readLock.lock();
            String partition = this.formatPartitionKey(partitionStr);
            this.ensurePartitionLoadedCorrectly(partition);
            Stream<HoodieFileGroup> stream = this.fetchAllStoredFileGroups(partition);
            return stream;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected abstract boolean isPendingCompactionScheduledForFileId(HoodieFileGroupId var1);

    abstract void resetPendingCompactionOperations(Stream<Pair<String, CompactionOperation>> var1);

    abstract void addPendingCompactionOperations(Stream<Pair<String, CompactionOperation>> var1);

    abstract void removePendingCompactionOperations(Stream<Pair<String, CompactionOperation>> var1);

    protected abstract Option<Pair<String, CompactionOperation>> getPendingCompactionOperationWithInstant(HoodieFileGroupId var1);

    abstract Stream<Pair<String, CompactionOperation>> fetchPendingCompactionOperations();

    abstract boolean isPartitionAvailableInStore(String var1);

    abstract void storePartitionView(String var1, List<HoodieFileGroup> var2);

    abstract Stream<HoodieFileGroup> fetchAllStoredFileGroups(String var1);

    abstract Stream<HoodieFileGroup> fetchAllStoredFileGroups();

    abstract boolean isClosed();

    Stream<FileSlice> fetchLatestFileSliceInRange(List<String> commitsToReturn) {
        return this.fetchAllStoredFileGroups().map(fileGroup -> fileGroup.getLatestFileSliceInRange(commitsToReturn)).map(Option::get);
    }

    Stream<FileSlice> fetchAllFileSlices(String partitionPath) {
        return this.fetchAllStoredFileGroups(partitionPath).map(HoodieFileGroup::getAllFileSlices).flatMap(sliceList -> sliceList);
    }

    Stream<HoodieBaseFile> fetchLatestBaseFiles(String partitionPath) {
        return this.fetchAllStoredFileGroups(partitionPath).map(this::getLatestBaseFile).filter(Option::isPresent).map(Option::get);
    }

    protected Option<HoodieBaseFile> getLatestBaseFile(HoodieFileGroup fileGroup) {
        return Option.fromJavaOptional(fileGroup.getAllBaseFiles().filter(df -> !this.isBaseFileDueToPendingCompaction((HoodieBaseFile)df)).findFirst());
    }

    Stream<HoodieBaseFile> fetchLatestBaseFiles() {
        return this.fetchAllStoredFileGroups().map(this::getLatestBaseFile).filter(Option::isPresent).map(Option::get);
    }

    Stream<HoodieBaseFile> fetchAllBaseFiles(String partitionPath) {
        return this.fetchAllStoredFileGroups(partitionPath).map(HoodieFileGroup::getAllBaseFiles).flatMap(baseFileList -> baseFileList);
    }

    Option<HoodieFileGroup> fetchHoodieFileGroup(String partitionPath, String fileId) {
        return Option.fromJavaOptional(this.fetchAllStoredFileGroups(partitionPath).filter(fileGroup -> fileGroup.getFileGroupId().getFileId().equals(fileId)).findFirst());
    }

    Stream<FileSlice> fetchLatestFileSlices(String partitionPath) {
        return this.fetchAllStoredFileGroups(partitionPath).map(HoodieFileGroup::getLatestFileSlice).filter(Option::isPresent).map(Option::get);
    }

    Stream<FileSlice> fetchLatestFileSlicesBeforeOrOn(String partitionPath, String maxCommitTime) {
        return this.fetchAllStoredFileGroups(partitionPath).map(fileGroup -> fileGroup.getLatestFileSliceBeforeOrOn(maxCommitTime)).filter(Option::isPresent).map(Option::get);
    }

    private static FileSlice mergeCompactionPendingFileSlices(FileSlice lastSlice, FileSlice penultimateSlice) {
        FileSlice merged = new FileSlice(penultimateSlice.getPartitionPath(), penultimateSlice.getBaseInstantTime(), penultimateSlice.getFileId());
        if (penultimateSlice.getBaseFile().isPresent()) {
            merged.setBaseFile(penultimateSlice.getBaseFile().get());
        }
        penultimateSlice.getLogFiles().forEach(merged::addLogFile);
        lastSlice.getLogFiles().forEach(merged::addLogFile);
        return merged;
    }

    private FileSlice fetchMergedFileSlice(HoodieFileGroup fileGroup, FileSlice fileSlice) {
        Option<Pair<String, CompactionOperation>> compactionOpWithInstant = this.getPendingCompactionOperationWithInstant(fileGroup.getFileGroupId());
        if (compactionOpWithInstant.isPresent()) {
            Option<FileSlice> prevFileSlice;
            String compactionInstantTime = compactionOpWithInstant.get().getKey();
            if (fileSlice.getBaseInstantTime().equals(compactionInstantTime) && (prevFileSlice = fileGroup.getLatestFileSliceBefore(compactionInstantTime)).isPresent()) {
                return AbstractTableFileSystemView.mergeCompactionPendingFileSlices(fileSlice, prevFileSlice.get());
            }
        }
        return fileSlice;
    }

    protected Option<HoodieBaseFile> fetchLatestBaseFile(String partitionPath, String fileId) {
        return Option.fromJavaOptional(this.fetchLatestBaseFiles(partitionPath).filter(fs -> fs.getFileId().equals(fileId)).findFirst());
    }

    protected Option<FileSlice> fetchLatestFileSlice(String partitionPath, String fileId) {
        return Option.fromJavaOptional(this.fetchLatestFileSlices(partitionPath).filter(fs -> fs.getFileId().equals(fileId)).findFirst());
    }

    @Override
    public Option<HoodieInstant> getLastInstant() {
        return this.getTimeline().lastInstant();
    }

    @Override
    public HoodieTimeline getTimeline() {
        return this.visibleCommitsAndCompactionTimeline;
    }

    @Override
    public void sync() {
        HoodieTimeline oldTimeline = this.getTimeline();
        HoodieTimeline newTimeline = this.metaClient.reloadActiveTimeline().filterCompletedAndCompactionInstants();
        try {
            this.writeLock.lock();
            this.runSync(oldTimeline, newTimeline);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void runSync(HoodieTimeline oldTimeline, HoodieTimeline newTimeline) {
        this.refreshTimeline(newTimeline);
        this.addedPartitions.clear();
        this.resetViewState();
        this.init(this.metaClient, newTimeline);
    }

    public HoodieTimeline getVisibleCommitsAndCompactionTimeline() {
        return this.visibleCommitsAndCompactionTimeline;
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ Boolean lambda$ensurePartitionLoadedCorrectly$5(String partitionPathStr) {
        beginTs = System.currentTimeMillis();
        if (!this.isPartitionAvailableInStore(partitionPathStr)) {
            try {
                AbstractTableFileSystemView.LOG.info((Object)("Building file system view for partition (" + partitionPathStr + ")"));
                partitionPath = FSUtils.getPartitionPath(this.metaClient.getBasePath(), partitionPathStr);
                FSUtils.createPathIfNotExists(this.metaClient.getFs(), partitionPath);
                beginLsTs = System.currentTimeMillis();
                statuses = this.metaClient.getFs().listStatus(partitionPath);
                endLsTs = System.currentTimeMillis();
                AbstractTableFileSystemView.LOG.info((Object)("#files found in partition (" + partitionPathStr + ") =" + statuses.length + ", Time taken =" + (endLsTs - beginLsTs)));
                groups = this.addFilesToView(statuses);
                if (!groups.isEmpty()) ** GOTO lbl18
                this.storePartitionView(partitionPathStr, new ArrayList<HoodieFileGroup>());
            }
            catch (IOException e) {
                throw new HoodieIOException("Failed to list base files in partition " + partitionPathStr, e);
            }
        } else {
            AbstractTableFileSystemView.LOG.debug((Object)("View already built for Partition :" + partitionPathStr + ", FOUND is "));
        }
lbl18:
        // 3 sources

        endTs = System.currentTimeMillis();
        AbstractTableFileSystemView.LOG.info((Object)("Time to load partition (" + partitionPathStr + ") =" + (endTs - beginTs)));
        return true;
    }
}

