/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanPartitionMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.common.HoodieCleanStat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.AvroUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.versioning.clean.CleanMetadataMigrator;
import org.apache.hudi.common.versioning.clean.CleanV1MigrationHandler;
import org.apache.hudi.common.versioning.clean.CleanV2MigrationHandler;

public class CleanerUtils {
    public static final Integer CLEAN_METADATA_VERSION_1 = CleanV1MigrationHandler.VERSION;
    public static final Integer CLEAN_METADATA_VERSION_2;
    public static final Integer LATEST_CLEAN_METADATA_VERSION;

    public static HoodieCleanMetadata convertCleanMetadata(HoodieTableMetaClient metaClient, String startCleanTime, Option<Long> durationInMs, List<HoodieCleanStat> cleanStats) {
        ImmutableMap.Builder partitionMetadataBuilder = ImmutableMap.builder();
        int totalDeleted = 0;
        String earliestCommitToRetain = null;
        for (HoodieCleanStat stat : cleanStats) {
            HoodieCleanPartitionMetadata metadata = new HoodieCleanPartitionMetadata(stat.getPartitionPath(), stat.getPolicy().name(), stat.getDeletePathPatterns(), stat.getSuccessDeleteFiles(), stat.getFailedDeleteFiles());
            partitionMetadataBuilder.put((Object)stat.getPartitionPath(), (Object)metadata);
            totalDeleted += stat.getSuccessDeleteFiles().size();
            if (earliestCommitToRetain != null) continue;
            earliestCommitToRetain = stat.getEarliestCommitToRetain();
        }
        HoodieCleanMetadata metadata = new HoodieCleanMetadata(startCleanTime, durationInMs.orElseGet(() -> -1L), totalDeleted, earliestCommitToRetain, (Map<String, HoodieCleanPartitionMetadata>)partitionMetadataBuilder.build(), CLEAN_METADATA_VERSION_2);
        return metadata;
    }

    public static HoodieCleanMetadata getCleanerMetadata(HoodieTableMetaClient metaClient, HoodieInstant cleanInstant) throws IOException {
        CleanMetadataMigrator metadataMigrator = new CleanMetadataMigrator(metaClient);
        HoodieCleanMetadata cleanMetadata = AvroUtils.deserializeHoodieCleanMetadata(metaClient.getActiveTimeline().readCleanerInfoAsBytes(cleanInstant).get());
        return metadataMigrator.upgradeToLatest(cleanMetadata, cleanMetadata.getVersion());
    }

    public static HoodieCleanerPlan getCleanerPlan(HoodieTableMetaClient metaClient, HoodieInstant cleanInstant) throws IOException {
        return AvroUtils.deserializeAvroMetadata(metaClient.getActiveTimeline().readCleanerInfoAsBytes(cleanInstant).get(), HoodieCleanerPlan.class);
    }

    static {
        LATEST_CLEAN_METADATA_VERSION = CLEAN_METADATA_VERSION_2 = CleanV2MigrationHandler.VERSION;
    }
}

