/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.model.TimelineLayoutVersion;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.collection.Pair;

public abstract class TimelineLayout
implements Serializable {
    private static final Map<TimelineLayoutVersion, TimelineLayout> LAYOUT_MAP = new HashMap<TimelineLayoutVersion, TimelineLayout>();

    public static TimelineLayout getLayout(TimelineLayoutVersion version) {
        return LAYOUT_MAP.get(version);
    }

    public abstract Stream<HoodieInstant> filterHoodieInstants(Stream<HoodieInstant> var1);

    static {
        LAYOUT_MAP.put(new TimelineLayoutVersion(TimelineLayoutVersion.VERSION_0), new TimelineLayoutV0());
        LAYOUT_MAP.put(new TimelineLayoutVersion(TimelineLayoutVersion.VERSION_1), new TimelineLayoutV1());
    }

    private static class TimelineLayoutV1
    extends TimelineLayout {
        private TimelineLayoutV1() {
        }

        @Override
        public Stream<HoodieInstant> filterHoodieInstants(Stream<HoodieInstant> instantStream) {
            return instantStream.collect(Collectors.groupingBy(instant -> Pair.of(instant.getTimestamp(), HoodieInstant.getComparableAction(instant.getAction())))).values().stream().map(hoodieInstants -> (HoodieInstant)hoodieInstants.stream().reduce((x, y) -> {
                if (x.getState().compareTo(y.getState()) >= 0) {
                    return x;
                }
                return y;
            }).get());
        }
    }

    private static class TimelineLayoutV0
    extends TimelineLayout {
        private TimelineLayoutV0() {
        }

        @Override
        public Stream<HoodieInstant> filterHoodieInstants(Stream<HoodieInstant> instantStream) {
            return instantStream;
        }
    }
}

