/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.log.HoodieLogFileReader;
import org.apache.hudi.common.table.log.HoodieLogFormatWriter;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.util.FSUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public interface HoodieLogFormat {
    public static final byte[] MAGIC = new byte[]{35, 72, 85, 68, 73, 35};
    public static final int CURRENT_VERSION = 1;
    public static final String UNKNOWN_WRITE_TOKEN = "1-0-1";

    public static WriterBuilder newWriterBuilder() {
        return new WriterBuilder();
    }

    public static Reader newReader(FileSystem fs, HoodieLogFile logFile, Schema readerSchema) throws IOException {
        return new HoodieLogFileReader(fs, logFile, readerSchema, 0x1000000, false, false);
    }

    public static Reader newReader(FileSystem fs, HoodieLogFile logFile, Schema readerSchema, boolean readBlockLazily, boolean reverseReader) throws IOException {
        return new HoodieLogFileReader(fs, logFile, readerSchema, 0x1000000, readBlockLazily, reverseReader);
    }

    public static abstract class LogFormatVersion {
        private final int version;

        LogFormatVersion(int version) {
            this.version = version;
        }

        public int getVersion() {
            return this.version;
        }

        public abstract boolean hasMagicHeader();

        public abstract boolean hasContent();

        public abstract boolean hasContentLength();

        public abstract boolean hasOrdinal();

        public abstract boolean hasHeader();

        public abstract boolean hasFooter();

        public abstract boolean hasLogBlockLength();
    }

    public static class WriterBuilder {
        private static final Logger LOG = LogManager.getLogger(WriterBuilder.class);
        public static final long DEFAULT_SIZE_THRESHOLD = 0x20000000L;
        private Integer bufferSize;
        private Short replication;
        private FileSystem fs;
        private Long sizeThreshold;
        private String fileExtension;
        private String logFileId;
        private String commitTime;
        private Integer logVersion;
        private Path parentPath;
        private String logWriteToken;
        private String rolloverLogWriteToken;

        public WriterBuilder withBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public WriterBuilder withReplication(short replication) {
            this.replication = replication;
            return this;
        }

        public WriterBuilder withLogWriteToken(String writeToken) {
            this.logWriteToken = writeToken;
            return this;
        }

        public WriterBuilder withRolloverLogWriteToken(String rolloverLogWriteToken) {
            this.rolloverLogWriteToken = rolloverLogWriteToken;
            return this;
        }

        public WriterBuilder withFs(FileSystem fs) {
            this.fs = fs;
            return this;
        }

        public WriterBuilder withSizeThreshold(long sizeThreshold) {
            this.sizeThreshold = sizeThreshold;
            return this;
        }

        public WriterBuilder withFileExtension(String logFileExtension) {
            this.fileExtension = logFileExtension;
            return this;
        }

        public WriterBuilder withFileId(String fileId) {
            this.logFileId = fileId;
            return this;
        }

        public WriterBuilder overBaseCommit(String baseCommit) {
            this.commitTime = baseCommit;
            return this;
        }

        public WriterBuilder withLogVersion(int version) {
            this.logVersion = version;
            return this;
        }

        public WriterBuilder onParentPath(Path parentPath) {
            this.parentPath = parentPath;
            return this;
        }

        public Writer build() throws IOException, InterruptedException {
            LOG.info((Object)"Building HoodieLogFormat Writer");
            if (this.fs == null) {
                throw new IllegalArgumentException("fs is not specified");
            }
            if (this.logFileId == null) {
                throw new IllegalArgumentException("FileID is not specified");
            }
            if (this.commitTime == null) {
                throw new IllegalArgumentException("BaseCommitTime is not specified");
            }
            if (this.fileExtension == null) {
                throw new IllegalArgumentException("File extension is not specified");
            }
            if (this.parentPath == null) {
                throw new IllegalArgumentException("Log file parent location is not specified");
            }
            if (this.rolloverLogWriteToken == null) {
                this.rolloverLogWriteToken = HoodieLogFormat.UNKNOWN_WRITE_TOKEN;
            }
            if (this.logVersion == null) {
                LOG.info((Object)("Computing the next log version for " + this.logFileId + " in " + this.parentPath));
                Option<Pair<Integer, String>> versionAndWriteToken = FSUtils.getLatestLogVersion(this.fs, this.parentPath, this.logFileId, this.fileExtension, this.commitTime);
                if (versionAndWriteToken.isPresent()) {
                    this.logVersion = versionAndWriteToken.get().getKey();
                    this.logWriteToken = versionAndWriteToken.get().getValue();
                } else {
                    this.logVersion = HoodieLogFile.LOGFILE_BASE_VERSION;
                    this.logWriteToken = this.rolloverLogWriteToken;
                }
                LOG.info((Object)("Computed the next log version for " + this.logFileId + " in " + this.parentPath + " as " + this.logVersion + " with write-token " + this.logWriteToken));
            }
            if (this.logWriteToken == null) {
                this.logVersion = this.logVersion + 1;
                this.logWriteToken = this.rolloverLogWriteToken;
            }
            Path logPath = new Path(this.parentPath, FSUtils.makeLogFileName(this.logFileId, this.fileExtension, this.commitTime, this.logVersion, this.logWriteToken));
            LOG.info((Object)("HoodieLogFile on path " + logPath));
            HoodieLogFile logFile = new HoodieLogFile(logPath);
            if (this.bufferSize == null) {
                this.bufferSize = FSUtils.getDefaultBufferSize(this.fs);
            }
            if (this.replication == null) {
                this.replication = FSUtils.getDefaultReplication(this.fs, this.parentPath);
            }
            if (this.sizeThreshold == null) {
                this.sizeThreshold = 0x20000000L;
            }
            return new HoodieLogFormatWriter(this.fs, logFile, this.bufferSize, this.replication, this.sizeThreshold, this.logWriteToken, this.rolloverLogWriteToken);
        }
    }

    public static interface Reader
    extends Closeable,
    Iterator<HoodieLogBlock> {
        public HoodieLogFile getLogFile();

        public boolean hasPrev();

        public HoodieLogBlock prev() throws IOException;
    }

    public static interface Writer
    extends Closeable {
        public HoodieLogFile getLogFile();

        public Writer appendBlock(HoodieLogBlock var1) throws IOException, InterruptedException;

        public long getCurrentSize() throws IOException;
    }
}

