/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.view;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTimeline;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.util.DefaultSizeEstimator;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SpillableMapBasedFileSystemView
extends HoodieTableFileSystemView {
    private static final Logger LOG = LogManager.getLogger(SpillableMapBasedFileSystemView.class);
    private final long maxMemoryForFileGroupMap;
    private final long maxMemoryForPendingCompaction;
    private final String baseStoreDir;

    public SpillableMapBasedFileSystemView(HoodieTableMetaClient metaClient, HoodieTimeline visibleActiveTimeline, FileSystemViewStorageConfig config) {
        super(config.isIncrementalTimelineSyncEnabled());
        this.maxMemoryForFileGroupMap = config.getMaxMemoryForFileGroupMap();
        this.maxMemoryForPendingCompaction = config.getMaxMemoryForPendingCompaction();
        this.baseStoreDir = config.getBaseStoreDir();
        this.init(metaClient, visibleActiveTimeline);
    }

    public SpillableMapBasedFileSystemView(HoodieTableMetaClient metaClient, HoodieTimeline visibleActiveTimeline, FileStatus[] fileStatuses, FileSystemViewStorageConfig config) {
        this(metaClient, visibleActiveTimeline, config);
        this.addFilesToView(fileStatuses);
    }

    @Override
    protected Map<String, List<HoodieFileGroup>> createPartitionToFileGroups() {
        try {
            LOG.info((Object)("Creating Partition To File groups map using external spillable Map. Max Mem=" + this.maxMemoryForFileGroupMap + ", BaseDir=" + this.baseStoreDir));
            new File(this.baseStoreDir).mkdirs();
            return new ExternalSpillableMap<String, List<HoodieFileGroup>>(this.maxMemoryForFileGroupMap, this.baseStoreDir, new DefaultSizeEstimator(), new DefaultSizeEstimator());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Map<HoodieFileGroupId, Pair<String, CompactionOperation>> createFileIdToPendingCompactionMap(Map<HoodieFileGroupId, Pair<String, CompactionOperation>> fgIdToPendingCompaction) {
        try {
            LOG.info((Object)("Creating Pending Compaction map using external spillable Map. Max Mem=" + this.maxMemoryForPendingCompaction + ", BaseDir=" + this.baseStoreDir));
            new File(this.baseStoreDir).mkdirs();
            ExternalSpillableMap<HoodieFileGroupId, Pair<String, CompactionOperation>> pendingMap = new ExternalSpillableMap<HoodieFileGroupId, Pair<String, CompactionOperation>>(this.maxMemoryForPendingCompaction, this.baseStoreDir, new DefaultSizeEstimator(), new DefaultSizeEstimator());
            pendingMap.putAll(fgIdToPendingCompaction);
            return pendingMap;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Stream<HoodieFileGroup> getAllFileGroups() {
        return ((ExternalSpillableMap)this.partitionToFileGroupsMap).valueStream().flatMap(fg -> ((List)fg).stream());
    }

    @Override
    Stream<Pair<String, CompactionOperation>> fetchPendingCompactionOperations() {
        return ((ExternalSpillableMap)this.fgIdToPendingCompaction).valueStream();
    }

    @Override
    public Stream<HoodieFileGroup> fetchAllStoredFileGroups() {
        return ((ExternalSpillableMap)this.partitionToFileGroupsMap).valueStream().flatMap(fg -> ((List)fg).stream());
    }
}

