/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.fs.Path;

public interface ConsistencyGuard {
    public void waitTillFileAppears(Path var1) throws IOException, TimeoutException;

    public void waitTillFileDisappears(Path var1) throws IOException, TimeoutException;

    public void waitTillAllFilesAppear(String var1, List<String> var2) throws IOException, TimeoutException;

    public void waitTillAllFilesDisappear(String var1, List<String> var2) throws IOException, TimeoutException;

    default public void waitTill(String dirPath, List<String> files, FileVisibility targetVisibility) throws IOException, TimeoutException {
        switch (targetVisibility) {
            case APPEAR: {
                this.waitTillAllFilesAppear(dirPath, files);
                break;
            }
            case DISAPPEAR: {
                this.waitTillAllFilesDisappear(dirPath, files);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown File Visibility");
            }
        }
    }

    public static enum FileVisibility {
        APPEAR,
        DISAPPEAR;

    }
}

