/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.util.TypedProperties;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class DFSPropertiesConfiguration {
    private static final Logger LOG = LogManager.getLogger(DFSPropertiesConfiguration.class);
    private final FileSystem fs;
    private final Path rootFile;
    private final TypedProperties props;
    private final Set<String> visitedFiles;

    public DFSPropertiesConfiguration(FileSystem fs, Path rootFile, TypedProperties defaults) {
        this.fs = fs;
        this.rootFile = rootFile;
        this.props = defaults;
        this.visitedFiles = new HashSet<String>();
        this.visitFile(rootFile);
    }

    public DFSPropertiesConfiguration(FileSystem fs, Path rootFile) {
        this(fs, rootFile, new TypedProperties());
    }

    public DFSPropertiesConfiguration() {
        this.fs = null;
        this.rootFile = null;
        this.props = new TypedProperties();
        this.visitedFiles = new HashSet<String>();
    }

    private String[] splitProperty(String line) {
        int ind = line.indexOf(61);
        String k = line.substring(0, ind).trim();
        String v = line.substring(ind + 1).trim();
        return new String[]{k, v};
    }

    private void visitFile(Path file) {
        try {
            if (this.visitedFiles.contains(file.getName())) {
                throw new IllegalStateException("Loop detected; file " + file + " already referenced");
            }
            this.visitedFiles.add(file.getName());
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)this.fs.open(file)));
            this.addProperties(reader);
        }
        catch (IOException ioe) {
            LOG.error((Object)"Error reading in properies from dfs", (Throwable)ioe);
            throw new IllegalArgumentException("Cannot read properties from dfs", ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperties(BufferedReader reader) throws IOException {
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || line.equals("") || !line.contains("=")) continue;
                String[] split = this.splitProperty(line);
                if (line.startsWith("include=") || line.startsWith("include =")) {
                    this.visitFile(new Path(this.rootFile.getParent(), split[1]));
                    continue;
                }
                this.props.setProperty(split[0], split[1]);
            }
        }
        finally {
            reader.close();
        }
    }

    public TypedProperties getConfig() {
        return this.props;
    }
}

