/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;

public class FileIOUtils {
    public static final long KB = 1024L;

    public static void deleteDirectory(File directory) throws IOException {
        if (directory.exists()) {
            Files.walk(directory.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            directory.delete();
            if (directory.exists()) {
                throw new IOException("Unable to delete directory " + directory);
            }
        }
    }

    public static void mkdir(File directory) throws IOException {
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if (!directory.isDirectory()) {
            throw new IOException("Unable to create :" + directory);
        }
    }

    public static String readAsUTFString(InputStream input) throws IOException {
        return FileIOUtils.readAsUTFString(input, 128);
    }

    public static String readAsUTFString(InputStream input, int length) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        FileIOUtils.copy(input, bos);
        return new String(bos.toByteArray(), StandardCharsets.UTF_8);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, len);
        }
    }

    public static byte[] readAsByteArray(InputStream input) throws IOException {
        return FileIOUtils.readAsByteArray(input, 128);
    }

    public static byte[] readAsByteArray(InputStream input, int outputSize) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(outputSize);
        FileIOUtils.copy(input, bos);
        return bos.toByteArray();
    }

    public static void writeStringToFile(String str, String filePath) throws IOException {
        PrintStream out = new PrintStream(new FileOutputStream(filePath));
        out.println(str);
        out.flush();
        out.close();
    }
}

