/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.SchemaCompatabilityException;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericData;
import org.apache.hudi.org.apache.avro.generic.GenericDatumReader;
import org.apache.hudi.org.apache.avro.generic.GenericDatumWriter;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.hudi.org.apache.avro.io.BinaryDecoder;
import org.apache.hudi.org.apache.avro.io.BinaryEncoder;
import org.apache.hudi.org.apache.avro.io.DecoderFactory;
import org.apache.hudi.org.apache.avro.io.EncoderFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.NullNode;

public class HoodieAvroUtils {
    private static ThreadLocal<BinaryEncoder> reuseEncoder = ThreadLocal.withInitial(() -> null);
    private static ThreadLocal<BinaryDecoder> reuseDecoder = ThreadLocal.withInitial(() -> null);
    private static final Schema METADATA_FIELD_SCHEMA = Schema.createUnion(Arrays.asList(Schema.create(Schema.Type.NULL), Schema.create(Schema.Type.STRING)));
    private static final Schema RECORD_KEY_SCHEMA = HoodieAvroUtils.initRecordKeySchema();

    public static byte[] avroToBytes(GenericRecord record) throws IOException {
        GenericDatumWriter<GenericRecord> writer = new GenericDatumWriter<GenericRecord>(record.getSchema());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder(out, reuseEncoder.get());
        reuseEncoder.set(encoder);
        writer.write(record, encoder);
        encoder.flush();
        out.close();
        return out.toByteArray();
    }

    public static GenericRecord bytesToAvro(byte[] bytes, Schema schema) throws IOException {
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(bytes, reuseDecoder.get());
        reuseDecoder.set(decoder);
        GenericDatumReader<Object> reader = new GenericDatumReader<Object>(schema);
        return reader.read(null, decoder);
    }

    public static boolean isMetadataField(String fieldName) {
        return HoodieRecord.COMMIT_TIME_METADATA_FIELD.equals(fieldName) || HoodieRecord.COMMIT_SEQNO_METADATA_FIELD.equals(fieldName) || HoodieRecord.RECORD_KEY_METADATA_FIELD.equals(fieldName) || HoodieRecord.PARTITION_PATH_METADATA_FIELD.equals(fieldName) || HoodieRecord.FILENAME_METADATA_FIELD.equals(fieldName);
    }

    public static Schema createHoodieWriteSchema(Schema originalSchema) {
        return HoodieAvroUtils.addMetadataFields(originalSchema);
    }

    public static Schema addMetadataFields(Schema schema) {
        ArrayList<Schema.Field> parentFields = new ArrayList<Schema.Field>();
        Schema.Field commitTimeField = new Schema.Field(HoodieRecord.COMMIT_TIME_METADATA_FIELD, METADATA_FIELD_SCHEMA, "", (Object)null);
        Schema.Field commitSeqnoField = new Schema.Field(HoodieRecord.COMMIT_SEQNO_METADATA_FIELD, METADATA_FIELD_SCHEMA, "", (Object)null);
        Schema.Field recordKeyField = new Schema.Field(HoodieRecord.RECORD_KEY_METADATA_FIELD, METADATA_FIELD_SCHEMA, "", (Object)null);
        Schema.Field partitionPathField = new Schema.Field(HoodieRecord.PARTITION_PATH_METADATA_FIELD, METADATA_FIELD_SCHEMA, "", (Object)null);
        Schema.Field fileNameField = new Schema.Field(HoodieRecord.FILENAME_METADATA_FIELD, METADATA_FIELD_SCHEMA, "", (Object)null);
        parentFields.add(commitTimeField);
        parentFields.add(commitSeqnoField);
        parentFields.add(recordKeyField);
        parentFields.add(partitionPathField);
        parentFields.add(fileNameField);
        for (Schema.Field field : schema.getFields()) {
            if (HoodieAvroUtils.isMetadataField(field.name())) continue;
            Schema.Field newField = new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultVal());
            for (Map.Entry<String, Object> prop : field.getObjectProps().entrySet()) {
                newField.addProp(prop.getKey(), prop.getValue());
            }
            parentFields.add(newField);
        }
        Schema mergedSchema = Schema.createRecord(schema.getName(), schema.getDoc(), schema.getNamespace(), false);
        mergedSchema.setFields(parentFields);
        return mergedSchema;
    }

    public static String addMetadataColumnTypes(String hiveColumnTypes) {
        return "string,string,string,string,string," + hiveColumnTypes;
    }

    private static Schema initRecordKeySchema() {
        Schema.Field recordKeyField = new Schema.Field(HoodieRecord.RECORD_KEY_METADATA_FIELD, METADATA_FIELD_SCHEMA, "", (JsonNode)NullNode.getInstance());
        Schema recordKeySchema = Schema.createRecord("HoodieRecordKey", "", "", false);
        recordKeySchema.setFields(Collections.singletonList(recordKeyField));
        return recordKeySchema;
    }

    public static Schema getRecordKeySchema() {
        return RECORD_KEY_SCHEMA;
    }

    public static GenericRecord addHoodieKeyToRecord(GenericRecord record, String recordKey, String partitionPath, String fileName) {
        record.put(HoodieRecord.FILENAME_METADATA_FIELD, (Object)fileName);
        record.put(HoodieRecord.PARTITION_PATH_METADATA_FIELD, (Object)partitionPath);
        record.put(HoodieRecord.RECORD_KEY_METADATA_FIELD, (Object)recordKey);
        return record;
    }

    public static Schema appendNullSchemaFields(Schema schema, List<String> newFieldNames) {
        List<Schema.Field> newFields = schema.getFields().stream().map(field -> new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultValue())).collect(Collectors.toList());
        for (String newField : newFieldNames) {
            newFields.add(new Schema.Field(newField, METADATA_FIELD_SCHEMA, "", (JsonNode)NullNode.getInstance()));
        }
        Schema newSchema = Schema.createRecord(schema.getName(), schema.getDoc(), schema.getNamespace(), schema.isError());
        newSchema.setFields(newFields);
        return newSchema;
    }

    public static Schema removeMetadataFields(Schema schema) {
        List<Schema.Field> filteredFields = schema.getFields().stream().filter(field -> !HoodieRecord.HOODIE_META_COLUMNS.contains(field.name())).collect(Collectors.toList());
        Schema filteredSchema = Schema.createRecord(schema.getName(), schema.getDoc(), schema.getNamespace(), false);
        filteredSchema.setFields(filteredFields);
        return filteredSchema;
    }

    public static GenericRecord addCommitMetadataToRecord(GenericRecord record, String commitTime, String commitSeqno) {
        record.put(HoodieRecord.COMMIT_TIME_METADATA_FIELD, (Object)commitTime);
        record.put(HoodieRecord.COMMIT_SEQNO_METADATA_FIELD, (Object)commitSeqno);
        return record;
    }

    public static GenericRecord rewriteRecord(GenericRecord record, Schema newSchema) {
        return HoodieAvroUtils.rewrite(record, HoodieAvroUtils.getCombinedFieldsToWrite(record.getSchema(), newSchema), newSchema);
    }

    public static GenericRecord rewriteRecordWithOnlyNewSchemaFields(GenericRecord record, Schema newSchema) {
        return HoodieAvroUtils.rewrite(record, new LinkedHashSet<Schema.Field>(newSchema.getFields()), newSchema);
    }

    private static GenericRecord rewrite(GenericRecord record, LinkedHashSet<Schema.Field> fieldsToWrite, Schema newSchema) {
        GenericData.Record newRecord = new GenericData.Record(newSchema);
        for (Schema.Field f : fieldsToWrite) {
            if (record.get(f.name()) == null) {
                newRecord.put(f.name(), f.defaultVal());
                continue;
            }
            newRecord.put(f.name(), record.get(f.name()));
        }
        if (!GenericData.get().validate(newSchema, newRecord)) {
            throw new SchemaCompatabilityException("Unable to validate the rewritten record " + record + " against schema " + newSchema);
        }
        return newRecord;
    }

    private static LinkedHashSet<Schema.Field> getCombinedFieldsToWrite(Schema oldSchema, Schema newSchema) {
        LinkedHashSet<Schema.Field> allFields = new LinkedHashSet<Schema.Field>(oldSchema.getFields());
        for (Schema.Field f : newSchema.getFields()) {
            if (allFields.contains(f) || HoodieAvroUtils.isMetadataField(f.name())) continue;
            allFields.add(f);
        }
        return allFields;
    }

    public static byte[] compress(String text) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            DeflaterOutputStream out = new DeflaterOutputStream(baos);
            ((OutputStream)out).write(text.getBytes(StandardCharsets.UTF_8));
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            throw new HoodieIOException("IOException while compressing text " + text, e);
        }
        return baos.toByteArray();
    }

    public static String decompress(byte[] bytes) {
        InflaterInputStream in = new InflaterInputStream(new ByteArrayInputStream(bytes));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buffer = new byte[8192];
            while ((len = ((InputStream)in).read(buffer)) > 0) {
                baos.write(buffer, 0, len);
            }
            return new String(baos.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new HoodieIOException("IOException while decompressing text", e);
        }
    }
}

