/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.ObjectSizeCalculator;
import org.apache.hudi.common.util.SizeEstimator;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieRecordSizeEstimator<T extends HoodieRecordPayload>
implements SizeEstimator<HoodieRecord<T>> {
    private static final Logger LOG = LogManager.getLogger(HoodieRecordSizeEstimator.class);
    private final long sizeOfSchema;

    public HoodieRecordSizeEstimator(Schema schema) {
        this.sizeOfSchema = ObjectSizeCalculator.getObjectSize(schema);
    }

    @Override
    public long sizeEstimate(HoodieRecord<T> hoodieRecord) {
        long sizeOfRecord = ObjectSizeCalculator.getObjectSize(hoodieRecord);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("SizeOfRecord => " + sizeOfRecord + " SizeOfSchema => " + this.sizeOfSchema));
        }
        return sizeOfRecord;
    }
}

