/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.collection;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.hudi.common.util.BufferedRandomAccessFile;
import org.apache.hudi.common.util.collection.DiskBasedMap;
import org.apache.hudi.exception.HoodieException;

public class LazyFileIterable<T, R>
implements Iterable<R> {
    private final String filePath;
    private final Map<T, DiskBasedMap.ValueMetadata> inMemoryMetadataOfSpilledData;

    public LazyFileIterable(String filePath, Map<T, DiskBasedMap.ValueMetadata> map) {
        this.filePath = filePath;
        this.inMemoryMetadataOfSpilledData = map;
    }

    @Override
    public Iterator<R> iterator() {
        try {
            return new LazyFileIterator(this.filePath, this.inMemoryMetadataOfSpilledData);
        }
        catch (IOException io) {
            throw new HoodieException("Unable to initialize iterator for file on disk", io);
        }
    }

    public class LazyFileIterator<T, R>
    implements Iterator<R> {
        private final String filePath;
        private BufferedRandomAccessFile readOnlyFileHandle;
        private final Iterator<Map.Entry<T, DiskBasedMap.ValueMetadata>> metadataIterator;

        public LazyFileIterator(String filePath, Map<T, DiskBasedMap.ValueMetadata> map) throws IOException {
            this.filePath = filePath;
            this.readOnlyFileHandle = new BufferedRandomAccessFile(filePath, "r", DiskBasedMap.BUFFER_SIZE);
            this.readOnlyFileHandle.seek(0L);
            this.metadataIterator = map.entrySet().stream().sorted((o1, o2) -> ((DiskBasedMap.ValueMetadata)o1.getValue()).getOffsetOfValue().compareTo(((DiskBasedMap.ValueMetadata)o2.getValue()).getOffsetOfValue())).collect(Collectors.toList()).iterator();
            this.addShutdownHook();
        }

        @Override
        public boolean hasNext() {
            boolean available = this.metadataIterator.hasNext();
            if (!available) {
                this.close();
            }
            return available;
        }

        @Override
        public R next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("next() called on EOF'ed stream. File :" + this.filePath);
            }
            Map.Entry<T, DiskBasedMap.ValueMetadata> entry = this.metadataIterator.next();
            return DiskBasedMap.get(entry.getValue(), this.readOnlyFileHandle);
        }

        @Override
        public void remove() {
            this.metadataIterator.remove();
        }

        @Override
        public void forEachRemaining(Consumer<? super R> action) {
            action.accept(this.next());
        }

        private void close() {
            if (this.readOnlyFileHandle != null) {
                try {
                    this.readOnlyFileHandle.close();
                    this.readOnlyFileHandle = null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private void addShutdownHook() {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    LazyFileIterator.this.close();
                }
            });
        }
    }
}

