/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.realtime;

import java.io.IOException;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.realtime.HoodieRealtimeFileSplit;
import org.apache.hudi.hadoop.realtime.RealtimeCompactedRecordReader;
import org.apache.hudi.hadoop.realtime.RealtimeUnmergedRecordReader;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieRealtimeRecordReader
implements RecordReader<NullWritable, ArrayWritable> {
    public static final String REALTIME_SKIP_MERGE_PROP = "hoodie.realtime.merge.skip";
    public static final String DEFAULT_REALTIME_SKIP_MERGE = "false";
    private static final Logger LOG = LogManager.getLogger(HoodieRealtimeRecordReader.class);
    private final RecordReader<NullWritable, ArrayWritable> reader;

    public HoodieRealtimeRecordReader(HoodieRealtimeFileSplit split, JobConf job, RecordReader<NullWritable, ArrayWritable> realReader) {
        this.reader = HoodieRealtimeRecordReader.constructRecordReader(split, job, realReader);
    }

    public static boolean canSkipMerging(JobConf jobConf) {
        return Boolean.parseBoolean(jobConf.get(REALTIME_SKIP_MERGE_PROP, DEFAULT_REALTIME_SKIP_MERGE));
    }

    private static RecordReader<NullWritable, ArrayWritable> constructRecordReader(HoodieRealtimeFileSplit split, JobConf jobConf, RecordReader<NullWritable, ArrayWritable> realReader) {
        try {
            if (HoodieRealtimeRecordReader.canSkipMerging(jobConf)) {
                LOG.info((Object)"Enabling un-merged reading of realtime records");
                return new RealtimeUnmergedRecordReader(split, jobConf, realReader);
            }
            return new RealtimeCompactedRecordReader(split, jobConf, realReader);
        }
        catch (IOException ex) {
            LOG.error((Object)"Got exception when constructing record reader", (Throwable)ex);
            throw new HoodieException(ex);
        }
    }

    public boolean next(NullWritable key, ArrayWritable value) throws IOException {
        return this.reader.next((Object)key, (Object)value);
    }

    public NullWritable createKey() {
        return (NullWritable)this.reader.createKey();
    }

    public ArrayWritable createValue() {
        return (ArrayWritable)this.reader.createValue();
    }

    public long getPos() throws IOException {
        return this.reader.getPos();
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public float getProgress() throws IOException {
        return this.reader.getProgress();
    }
}

