/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.config;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;

public class TypedProperties
extends Properties
implements Serializable {
    public TypedProperties() {
        super((Properties)null);
    }

    public TypedProperties(Properties defaults) {
        super(defaults);
    }

    private void checkKey(String property) {
        if (!this.containsKey(property)) {
            throw new IllegalArgumentException("Property " + property + " not found");
        }
    }

    public String getString(String property) {
        this.checkKey(property);
        return this.getProperty(property);
    }

    public String getString(String property, String defaultValue) {
        return this.containsKey(property) ? this.getProperty(property) : defaultValue;
    }

    public List<String> getStringList(String property, String delimiter, List<String> defaultVal) {
        if (!this.containsKey(property)) {
            return defaultVal;
        }
        return Arrays.stream(this.getProperty(property).split(delimiter)).map(String::trim).collect(Collectors.toList());
    }

    public int getInteger(String property) {
        this.checkKey(property);
        return Integer.parseInt(this.getProperty(property));
    }

    public int getInteger(String property, int defaultValue) {
        return this.containsKey(property) ? Integer.parseInt(this.getProperty(property)) : defaultValue;
    }

    public long getLong(String property) {
        this.checkKey(property);
        return Long.parseLong(this.getProperty(property));
    }

    public long getLong(String property, long defaultValue) {
        return this.containsKey(property) ? Long.parseLong(this.getProperty(property)) : defaultValue;
    }

    public boolean getBoolean(String property) {
        this.checkKey(property);
        return Boolean.parseBoolean(this.getProperty(property));
    }

    public boolean getBoolean(String property, boolean defaultValue) {
        return this.containsKey(property) ? Boolean.parseBoolean(this.getProperty(property)) : defaultValue;
    }

    public double getDouble(String property) {
        this.checkKey(property);
        return Double.parseDouble(this.getProperty(property));
    }

    public double getDouble(String property, double defaultValue) {
        return this.containsKey(property) ? Double.parseDouble(this.getProperty(property)) : defaultValue;
    }
}

