/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs;

import java.util.Arrays;

public enum StorageSchemes {
    FILE("file", false),
    HDFS("hdfs", true),
    MAPRFS("maprfs", true),
    IGNITE("igfs", true),
    S3A("s3a", false),
    S3("s3", false),
    GCS("gs", false),
    WASB("wasb", false),
    WASBS("wasbs", false),
    ADL("adl", false),
    ABFS("abfs", false),
    ABFSS("abfss", false),
    OSS("oss", false),
    VIEWFS("viewfs", true),
    ALLUXIO("alluxio", false),
    COSN("cosn", false),
    DBFS("dbfs", false);

    private String scheme;
    private boolean supportsAppend;

    private StorageSchemes(String scheme, boolean supportsAppend) {
        this.scheme = scheme;
        this.supportsAppend = supportsAppend;
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean supportsAppend() {
        return this.supportsAppend;
    }

    public static boolean isSchemeSupported(String scheme) {
        return Arrays.stream(StorageSchemes.values()).anyMatch(s -> s.getScheme().equals(scheme));
    }

    public static boolean isAppendSupported(String scheme) {
        if (!StorageSchemes.isSchemeSupported(scheme)) {
            throw new IllegalArgumentException("Unsupported scheme :" + scheme);
        }
        return Arrays.stream(StorageSchemes.values()).anyMatch(s -> s.supportsAppend() && s.scheme.equals(scheme));
    }
}

