/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.Serializable;
import java.util.Objects;
import org.apache.hudi.avro.model.HoodieFileStatus;
import org.apache.hudi.common.model.HoodieFileGroupId;

public class BootstrapFileMapping
implements Serializable,
Comparable<BootstrapFileMapping> {
    private final String bootstrapBasePath;
    private final String bootstrapPartitionPath;
    private final HoodieFileStatus boostrapFileStatus;
    private final String partitionPath;
    private final String fileId;

    public BootstrapFileMapping(String bootstrapBasePath, String bootstrapPartitionPath, String partitionPath, HoodieFileStatus boostrapFileStatus, String fileId) {
        this.bootstrapBasePath = bootstrapBasePath;
        this.bootstrapPartitionPath = bootstrapPartitionPath;
        this.partitionPath = partitionPath;
        this.boostrapFileStatus = boostrapFileStatus;
        this.fileId = fileId;
    }

    public String toString() {
        return "BootstrapFileMapping{bootstrapBasePath='" + this.bootstrapBasePath + '\'' + ", bootstrapPartitionPath='" + this.bootstrapPartitionPath + '\'' + ", boostrapFileStatus=" + this.boostrapFileStatus + ", partitionPath='" + this.partitionPath + '\'' + ", fileId='" + this.fileId + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BootstrapFileMapping mapping = (BootstrapFileMapping)o;
        return Objects.equals(this.bootstrapBasePath, mapping.bootstrapBasePath) && Objects.equals(this.bootstrapPartitionPath, mapping.bootstrapPartitionPath) && Objects.equals(this.partitionPath, mapping.partitionPath) && Objects.equals(this.boostrapFileStatus, mapping.boostrapFileStatus) && Objects.equals(this.fileId, mapping.fileId);
    }

    public int hashCode() {
        return Objects.hash(this.bootstrapBasePath, this.bootstrapPartitionPath, this.partitionPath, this.boostrapFileStatus, this.fileId);
    }

    public String getBootstrapBasePath() {
        return this.bootstrapBasePath;
    }

    public String getBootstrapPartitionPath() {
        return this.bootstrapPartitionPath;
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public HoodieFileStatus getBoostrapFileStatus() {
        return this.boostrapFileStatus;
    }

    public String getFileId() {
        return this.fileId;
    }

    public HoodieFileGroupId getFileGroupId() {
        return new HoodieFileGroupId(this.partitionPath, this.fileId);
    }

    @Override
    public int compareTo(BootstrapFileMapping o) {
        int ret = this.partitionPath.compareTo(o.partitionPath);
        if (ret == 0) {
            ret = this.fileId.compareTo(o.fileId);
        }
        return ret;
    }
}

