/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;

public class HoodieLogFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DELTA_EXTENSION = ".log";
    public static final Integer LOGFILE_BASE_VERSION = 1;
    private transient FileStatus fileStatus;
    private final String pathStr;
    private long fileLen;

    public HoodieLogFile(HoodieLogFile logFile) {
        this.fileStatus = logFile.fileStatus;
        this.pathStr = logFile.pathStr;
        this.fileLen = logFile.fileLen;
    }

    public HoodieLogFile(FileStatus fileStatus) {
        this.fileStatus = fileStatus;
        this.pathStr = fileStatus.getPath().toString();
        this.fileLen = fileStatus.getLen();
    }

    public HoodieLogFile(Path logPath) {
        this.fileStatus = null;
        this.pathStr = logPath.toString();
        this.fileLen = 0L;
    }

    public HoodieLogFile(String logPathStr) {
        this.fileStatus = null;
        this.pathStr = logPathStr;
        this.fileLen = -1L;
    }

    public String getFileId() {
        return FSUtils.getFileIdFromLogPath(this.getPath());
    }

    public String getBaseCommitTime() {
        return FSUtils.getBaseCommitTimeFromLogPath(this.getPath());
    }

    public int getLogVersion() {
        return FSUtils.getFileVersionFromLog(this.getPath());
    }

    public String getLogWriteToken() {
        return FSUtils.getWriteTokenFromLogPath(this.getPath());
    }

    public String getFileExtension() {
        return FSUtils.getFileExtensionFromLog(this.getPath());
    }

    public Path getPath() {
        return new Path(this.pathStr);
    }

    public String getFileName() {
        return this.getPath().getName();
    }

    public void setFileLen(long fileLen) {
        this.fileLen = fileLen;
    }

    public long getFileSize() {
        return this.fileLen;
    }

    public FileStatus getFileStatus() {
        return this.fileStatus;
    }

    public void setFileStatus(FileStatus fileStatus) {
        this.fileStatus = fileStatus;
    }

    public HoodieLogFile rollOver(FileSystem fs, String logWriteToken) throws IOException {
        String fileId = this.getFileId();
        String baseCommitTime = this.getBaseCommitTime();
        Path path = this.getPath();
        String extension = "." + FSUtils.getFileExtensionFromLog(path);
        int newVersion = FSUtils.computeNextLogVersion(fs, path.getParent(), fileId, extension, baseCommitTime);
        return new HoodieLogFile(new Path(path.getParent(), FSUtils.makeLogFileName(fileId, extension, baseCommitTime, newVersion, logWriteToken)));
    }

    public static Comparator<HoodieLogFile> getLogFileComparator() {
        return new LogFileComparator();
    }

    public static Comparator<HoodieLogFile> getReverseLogFileComparator() {
        return new LogFileComparator().reversed();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoodieLogFile that = (HoodieLogFile)o;
        return Objects.equals(this.pathStr, that.pathStr);
    }

    public int hashCode() {
        return Objects.hash(this.pathStr);
    }

    public String toString() {
        return "HoodieLogFile{pathStr='" + this.pathStr + '\'' + ", fileLen=" + this.fileLen + '}';
    }

    public static class LogFileComparator
    implements Comparator<HoodieLogFile>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private transient Comparator<String> writeTokenComparator;

        private Comparator<String> getWriteTokenComparator() {
            if (null == this.writeTokenComparator) {
                this.writeTokenComparator = Comparator.nullsFirst(Comparator.naturalOrder());
            }
            return this.writeTokenComparator;
        }

        @Override
        public int compare(HoodieLogFile o1, HoodieLogFile o2) {
            String baseInstantTime2;
            String baseInstantTime1 = o1.getBaseCommitTime();
            if (baseInstantTime1.equals(baseInstantTime2 = o2.getBaseCommitTime())) {
                if (o1.getLogVersion() == o2.getLogVersion()) {
                    return this.getWriteTokenComparator().compare(o1.getLogWriteToken(), o2.getLogWriteToken());
                }
                return Integer.compare(o1.getLogVersion(), o2.getLogVersion());
            }
            return baseInstantTime1.compareTo(baseInstantTime2);
        }
    }
}

