/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.util.Locale;
import org.apache.hudi.exception.HoodieException;

public enum WriteOperationType {
    INSERT("insert"),
    INSERT_PREPPED("insert_prepped"),
    UPSERT("upsert"),
    UPSERT_PREPPED("upsert_prepped"),
    BULK_INSERT("bulk_insert"),
    BULK_INSERT_PREPPED("bulk_insert_prepped"),
    DELETE("delete"),
    BOOTSTRAP("bootstrap"),
    UNKNOWN("unknown");

    private final String value;

    private WriteOperationType(String value) {
        this.value = value;
    }

    public static WriteOperationType fromValue(String value) {
        switch (value.toLowerCase(Locale.ROOT)) {
            case "insert": {
                return INSERT;
            }
            case "insert_prepped": {
                return INSERT_PREPPED;
            }
            case "upsert": {
                return UPSERT;
            }
            case "upsert_prepped": {
                return UPSERT_PREPPED;
            }
            case "bulk_insert": {
                return BULK_INSERT;
            }
            case "bulk_insert_prepped": {
                return BULK_INSERT_PREPPED;
            }
            case "delete": {
                return DELETE;
            }
        }
        throw new HoodieException("Invalid value of Type.");
    }

    public static boolean isChangingRecords(WriteOperationType operationType) {
        return operationType == UPSERT || operationType == UPSERT_PREPPED || operationType == DELETE;
    }
}

