/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log.block;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;

public abstract class HoodieDataBlock
extends HoodieLogBlock {
    protected List<IndexedRecord> records;
    protected Schema schema;

    public HoodieDataBlock(@Nonnull Map<HoodieLogBlock.HeaderMetadataType, String> logBlockHeader, @Nonnull Map<HoodieLogBlock.HeaderMetadataType, String> logBlockFooter, @Nonnull Option<HoodieLogBlock.HoodieLogBlockContentLocation> blockContentLocation, @Nonnull Option<byte[]> content, FSDataInputStream inputStream, boolean readBlockLazily) {
        super(logBlockHeader, logBlockFooter, blockContentLocation, content, inputStream, readBlockLazily);
    }

    public HoodieDataBlock(@Nonnull List<IndexedRecord> records, @Nonnull Map<HoodieLogBlock.HeaderMetadataType, String> header, @Nonnull Map<HoodieLogBlock.HeaderMetadataType, String> footer) {
        super(header, footer, Option.empty(), Option.empty(), null, false);
        this.records = records;
        this.schema = new Schema.Parser().parse(super.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.SCHEMA));
    }

    public HoodieDataBlock(@Nonnull List<IndexedRecord> records, @Nonnull Map<HoodieLogBlock.HeaderMetadataType, String> header) {
        this(records, header, new HashMap<HoodieLogBlock.HeaderMetadataType, String>());
    }

    protected HoodieDataBlock(Option<byte[]> content, @Nonnull FSDataInputStream inputStream, boolean readBlockLazily, Option<HoodieLogBlock.HoodieLogBlockContentLocation> blockContentLocation, Schema readerSchema, @Nonnull Map<HoodieLogBlock.HeaderMetadataType, String> headers, @Nonnull Map<HoodieLogBlock.HeaderMetadataType, String> footer) {
        super(headers, footer, blockContentLocation, content, inputStream, readBlockLazily);
        this.schema = readerSchema;
    }

    public static HoodieLogBlock getBlock(HoodieLogBlock.HoodieLogBlockType logDataBlockFormat, List<IndexedRecord> recordList, Map<HoodieLogBlock.HeaderMetadataType, String> header) {
        switch (logDataBlockFormat) {
            case AVRO_DATA_BLOCK: {
                return new HoodieAvroDataBlock(recordList, header);
            }
        }
        throw new HoodieException("Data block format " + (Object)((Object)logDataBlockFormat) + " not implemented");
    }

    @Override
    public byte[] getContentBytes() throws IOException {
        if (this.getContent().isPresent()) {
            return this.getContent().get();
        }
        if (this.readBlockLazily && !this.getContent().isPresent() && this.records == null) {
            this.createRecordsFromContentBytes();
        }
        return this.serializeRecords();
    }

    @Override
    public abstract HoodieLogBlock.HoodieLogBlockType getBlockType();

    public List<IndexedRecord> getRecords() {
        if (this.records == null) {
            try {
                this.createRecordsFromContentBytes();
            }
            catch (IOException io) {
                throw new HoodieIOException("Unable to convert content bytes to records", io);
            }
        }
        return this.records;
    }

    public Schema getSchema() {
        if (this.records == null) {
            this.getRecords();
        }
        return this.schema;
    }

    private void createRecordsFromContentBytes() throws IOException {
        if (this.readBlockLazily && !this.getContent().isPresent()) {
            this.inflate();
        }
        this.deserializeRecords();
    }

    protected abstract byte[] serializeRecords() throws IOException;

    protected abstract void deserializeRecords() throws IOException;
}

