/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.view;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.table.view.IncrementalTimelineSyncFileSystemView;
import org.apache.hudi.common.table.view.PriorityBasedFileSystemView;
import org.apache.hudi.common.table.view.RemoteHoodieTableFileSystemView;
import org.apache.hudi.common.table.view.RocksDbBasedFileSystemView;
import org.apache.hudi.common.table.view.SpillableMapBasedFileSystemView;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.util.Functions;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class FileSystemViewManager {
    private static final Logger LOG = LogManager.getLogger(FileSystemViewManager.class);
    private final SerializableConfiguration conf;
    private final FileSystemViewStorageConfig viewStorageConfig;
    private final ConcurrentHashMap<String, SyncableFileSystemView> globalViewMap;
    private final Functions.Function2<HoodieTableMetaClient, FileSystemViewStorageConfig, SyncableFileSystemView> viewCreator;

    public FileSystemViewManager(SerializableConfiguration conf, FileSystemViewStorageConfig viewStorageConfig, Functions.Function2<HoodieTableMetaClient, FileSystemViewStorageConfig, SyncableFileSystemView> viewCreator) {
        this.conf = new SerializableConfiguration(conf);
        this.viewStorageConfig = viewStorageConfig;
        this.globalViewMap = new ConcurrentHashMap();
        this.viewCreator = viewCreator;
    }

    public void clearFileSystemView(String basePath) {
        SyncableFileSystemView view = this.globalViewMap.remove(basePath);
        if (view != null) {
            view.close();
        }
    }

    public SyncableFileSystemView getFileSystemView(String basePath) {
        return this.globalViewMap.computeIfAbsent(basePath, path -> {
            HoodieTableMetaClient metaClient = new HoodieTableMetaClient(this.conf.newCopy(), (String)path);
            return this.viewCreator.apply(metaClient, this.viewStorageConfig);
        });
    }

    public SyncableFileSystemView getFileSystemView(HoodieTableMetaClient metaClient) {
        return this.globalViewMap.computeIfAbsent(metaClient.getBasePath(), path -> this.viewCreator.apply(metaClient, this.viewStorageConfig));
    }

    public void close() {
        this.globalViewMap.values().forEach(SyncableFileSystemView::close);
        this.globalViewMap.clear();
    }

    private static RocksDbBasedFileSystemView createRocksDBBasedFileSystemView(SerializableConfiguration conf, FileSystemViewStorageConfig viewConf, HoodieTableMetaClient metaClient) {
        HoodieTimeline timeline = metaClient.getActiveTimeline().filterCompletedAndCompactionInstants();
        return new RocksDbBasedFileSystemView(metaClient, timeline, viewConf);
    }

    private static SpillableMapBasedFileSystemView createSpillableMapBasedFileSystemView(SerializableConfiguration conf, FileSystemViewStorageConfig viewConf, HoodieTableMetaClient metaClient) {
        LOG.info((Object)("Creating SpillableMap based view for basePath " + metaClient.getBasePath()));
        HoodieTimeline timeline = metaClient.getActiveTimeline().filterCompletedAndCompactionInstants();
        return new SpillableMapBasedFileSystemView(metaClient, timeline, viewConf);
    }

    private static HoodieTableFileSystemView createInMemoryFileSystemView(SerializableConfiguration conf, FileSystemViewStorageConfig viewConf, HoodieTableMetaClient metaClient) {
        LOG.info((Object)("Creating InMemory based view for basePath " + metaClient.getBasePath()));
        HoodieTimeline timeline = metaClient.getActiveTimeline().filterCompletedAndCompactionInstants();
        return new HoodieTableFileSystemView(metaClient, timeline, viewConf.isIncrementalTimelineSyncEnabled());
    }

    private static RemoteHoodieTableFileSystemView createRemoteFileSystemView(SerializableConfiguration conf, FileSystemViewStorageConfig viewConf, HoodieTableMetaClient metaClient) {
        LOG.info((Object)("Creating remote view for basePath " + metaClient.getBasePath() + ". Server=" + viewConf.getRemoteViewServerHost() + ":" + viewConf.getRemoteViewServerPort()));
        return new RemoteHoodieTableFileSystemView(viewConf.getRemoteViewServerHost(), viewConf.getRemoteViewServerPort(), metaClient);
    }

    public static FileSystemViewManager createViewManager(SerializableConfiguration conf, FileSystemViewStorageConfig config) {
        LOG.info((Object)("Creating View Manager with storage type :" + (Object)((Object)config.getStorageType())));
        switch (config.getStorageType()) {
            case EMBEDDED_KV_STORE: {
                LOG.info((Object)"Creating embedded rocks-db based Table View");
                return new FileSystemViewManager(conf, config, (metaClient, viewConf) -> FileSystemViewManager.createRocksDBBasedFileSystemView(conf, viewConf, metaClient));
            }
            case SPILLABLE_DISK: {
                LOG.info((Object)"Creating Spillable Disk based Table View");
                return new FileSystemViewManager(conf, config, (metaClient, viewConf) -> FileSystemViewManager.createSpillableMapBasedFileSystemView(conf, viewConf, metaClient));
            }
            case MEMORY: {
                LOG.info((Object)"Creating in-memory based Table View");
                return new FileSystemViewManager(conf, config, (metaClient, viewConfig) -> FileSystemViewManager.createInMemoryFileSystemView(conf, viewConfig, metaClient));
            }
            case REMOTE_ONLY: {
                LOG.info((Object)"Creating remote only table view");
                return new FileSystemViewManager(conf, config, (metaClient, viewConfig) -> FileSystemViewManager.createRemoteFileSystemView(conf, viewConfig, metaClient));
            }
            case REMOTE_FIRST: {
                LOG.info((Object)"Creating remote first table view");
                return new FileSystemViewManager(conf, config, (metaClient, viewConfig) -> {
                    IncrementalTimelineSyncFileSystemView secondaryView;
                    RemoteHoodieTableFileSystemView remoteFileSystemView = FileSystemViewManager.createRemoteFileSystemView(conf, viewConfig, metaClient);
                    switch (viewConfig.getSecondaryStorageType()) {
                        case MEMORY: {
                            secondaryView = FileSystemViewManager.createInMemoryFileSystemView(conf, viewConfig, metaClient);
                            break;
                        }
                        case EMBEDDED_KV_STORE: {
                            secondaryView = FileSystemViewManager.createRocksDBBasedFileSystemView(conf, viewConfig, metaClient);
                            break;
                        }
                        case SPILLABLE_DISK: {
                            secondaryView = FileSystemViewManager.createSpillableMapBasedFileSystemView(conf, viewConfig, metaClient);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Secondary Storage type can only be in-memory or spillable. Was :" + (Object)((Object)viewConfig.getSecondaryStorageType()));
                        }
                    }
                    return new PriorityBasedFileSystemView(remoteFileSystemView, secondaryView);
                });
            }
        }
        throw new IllegalArgumentException("Unknown file system view type :" + (Object)((Object)config.getStorageType()));
    }
}

