/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.TableNotFoundException;
import org.apache.hudi.hadoop.utils.HoodieHiveUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieROTablePathFilter
implements Configurable,
PathFilter,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger(HoodieROTablePathFilter.class);
    private Map<String, HashSet<Path>> hoodiePathCache = new HashMap<String, HashSet<Path>>();
    private Set<String> nonHoodiePathCache = new HashSet<String>();
    Map<String, HoodieTableMetaClient> metaClientCache;
    private SerializableConfiguration conf;
    private transient FileSystem fs;

    public HoodieROTablePathFilter() {
        this(new Configuration());
    }

    public HoodieROTablePathFilter(Configuration conf) {
        this.conf = new SerializableConfiguration(conf);
        this.metaClientCache = new HashMap<String, HoodieTableMetaClient>();
    }

    private Path safeGetParentsParent(Path path) {
        if (path.getParent() != null && path.getParent().getParent() != null && path.getParent().getParent().getParent() != null) {
            return path.getParent().getParent().getParent();
        }
        return null;
    }

    public boolean accept(Path path) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking acceptance for path " + path));
        }
        Path folder = null;
        try {
            Path baseDir;
            if (this.fs == null) {
                this.fs = path.getFileSystem(this.conf.get());
            }
            if (this.nonHoodiePathCache.contains((folder = path.getParent()).toString())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Accepting non-hoodie path from cache: " + path));
                }
                return true;
            }
            if (this.hoodiePathCache.containsKey(folder.toString())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("%s Hoodie path checked against cache, accept => %s \n", path, this.hoodiePathCache.get(folder.toString()).contains(path)));
                }
                return this.hoodiePathCache.get(folder.toString()).contains(path);
            }
            String filePath = path.toString();
            if (filePath.contains("/.hoodie/") || filePath.endsWith("/.hoodie")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Skipping Hoodie Metadata file  %s \n", filePath));
                }
                return false;
            }
            if (HoodiePartitionMetadata.hasPartitionMetadata(this.fs, folder)) {
                HoodiePartitionMetadata metadata = new HoodiePartitionMetadata(this.fs, folder);
                metadata.readFromFS();
                baseDir = HoodieHiveUtils.getNthParent(folder, metadata.getPartitionDepth());
            } else {
                baseDir = this.safeGetParentsParent(folder);
            }
            if (baseDir != null) {
                try {
                    HoodieTableMetaClient metaClient = this.metaClientCache.get(baseDir.toString());
                    if (null == metaClient) {
                        metaClient = new HoodieTableMetaClient(this.fs.getConf(), baseDir.toString(), true);
                        this.metaClientCache.put(baseDir.toString(), metaClient);
                    }
                    HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(metaClient, metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants(), this.fs.listStatus(folder));
                    List latestFiles = fsView.getLatestBaseFiles().collect(Collectors.toList());
                    if (!this.hoodiePathCache.containsKey(folder.toString())) {
                        this.hoodiePathCache.put(folder.toString(), new HashSet());
                    }
                    LOG.info((Object)("Based on hoodie metadata from base path: " + baseDir.toString() + ", caching " + latestFiles.size() + " files under " + folder));
                    for (HoodieBaseFile lfile : latestFiles) {
                        this.hoodiePathCache.get(folder.toString()).add(new Path(lfile.getPath()));
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)String.format("%s checked after cache population, accept => %s \n", path, this.hoodiePathCache.get(folder.toString()).contains(path)));
                    }
                    return this.hoodiePathCache.get(folder.toString()).contains(path);
                }
                catch (TableNotFoundException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)String.format("(1) Caching non-hoodie path under %s \n", folder.toString()));
                    }
                    this.nonHoodiePathCache.add(folder.toString());
                    return true;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("(2) Caching non-hoodie path under %s \n", folder.toString()));
            }
            this.nonHoodiePathCache.add(folder.toString());
            return true;
        }
        catch (Exception e) {
            String msg = "Error checking path :" + path + ", under folder: " + folder;
            LOG.error((Object)msg, (Throwable)e);
            throw new HoodieException(msg, e);
        }
    }

    public void setConf(Configuration conf) {
        this.conf = new SerializableConfiguration(conf);
    }

    public Configuration getConf() {
        return this.conf.get();
    }
}

