/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.realtime;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hudi.common.table.timeline.HoodieDefaultTimeline;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.hadoop.HoodieColumnProjectionUtils;
import org.apache.hudi.hadoop.HoodieParquetInputFormat;
import org.apache.hudi.hadoop.UseFileSplitsFromInputFormat;
import org.apache.hudi.hadoop.UseRecordReaderFromInputFormat;
import org.apache.hudi.hadoop.realtime.HoodieRealtimeRecordReader;
import org.apache.hudi.hadoop.realtime.RealtimeSplit;
import org.apache.hudi.hadoop.utils.HoodieRealtimeInputFormatUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@UseRecordReaderFromInputFormat
@UseFileSplitsFromInputFormat
public class HoodieParquetRealtimeInputFormat
extends HoodieParquetInputFormat
implements Configurable {
    private static final Logger LOG = LogManager.getLogger(HoodieParquetRealtimeInputFormat.class);

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        Stream<FileSplit> fileSplits = Arrays.stream(super.getSplits(job, numSplits)).map(is -> (FileSplit)is);
        return HoodieRealtimeInputFormatUtils.getRealtimeSplits((Configuration)job, fileSplits);
    }

    @Override
    public FileStatus[] listStatus(JobConf job) throws IOException {
        return super.listStatus(job);
    }

    @Override
    protected HoodieDefaultTimeline filterInstantsTimeline(HoodieDefaultTimeline timeline) {
        return timeline;
    }

    private static Configuration addProjectionField(Configuration conf, String fieldName, int fieldIndex) {
        String readColNames = conf.get("hive.io.file.readcolumn.names", "");
        String readColIds = conf.get("hive.io.file.readcolumn.ids", "");
        String readColNamesPrefix = readColNames + ",";
        if (readColNames == null || readColNames.isEmpty()) {
            readColNamesPrefix = "";
        }
        String readColIdsPrefix = readColIds + ",";
        if (readColIds == null || readColIds.isEmpty()) {
            readColIdsPrefix = "";
        }
        if (!readColNames.contains(fieldName)) {
            conf.set("hive.io.file.readcolumn.names", readColNamesPrefix + fieldName);
            conf.set("hive.io.file.readcolumn.ids", readColIdsPrefix + fieldIndex);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Adding extra column " + fieldName + ", to enable log merging cols (%s) ids (%s) ", conf.get("hive.io.file.readcolumn.names"), conf.get("hive.io.file.readcolumn.ids")));
            }
        }
        return conf;
    }

    private static void addRequiredProjectionFields(Configuration configuration) {
        ArrayList<Integer> projectedIds = new ArrayList<Integer>(HoodieColumnProjectionUtils.getReadColumnIDs(configuration));
        ArrayList<String> projectedNames = new ArrayList<String>(Arrays.asList(HoodieColumnProjectionUtils.getReadColumnNames(configuration)));
        projectedIds.addAll(Arrays.asList(2, 0, 3));
        projectedNames.addAll(Arrays.asList("_hoodie_record_key", "_hoodie_commit_time", "_hoodie_partition_path"));
        HoodieColumnProjectionUtils.setReadColumns(configuration, projectedIds, projectedNames);
    }

    private static void cleanProjectionColumnIds(Configuration conf) {
        String columnIds = conf.get("hive.io.file.readcolumn.ids");
        if (!columnIds.isEmpty() && columnIds.charAt(0) == ',') {
            conf.set("hive.io.file.readcolumn.ids", columnIds.substring(1));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The projection Ids: {" + columnIds + "} start with ','. First comma is removed"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordReader<NullWritable, ArrayWritable> getRecordReader(InputSplit split, JobConf jobConf, Reporter reporter) throws IOException {
        if (jobConf.get("hoodie.read.columns.set") == null) {
            JobConf jobConf2 = jobConf;
            synchronized (jobConf2) {
                LOG.info((Object)("Before adding Hoodie columns, Projections :" + jobConf.get("hive.io.file.readcolumn.names") + ", Ids :" + jobConf.get("hive.io.file.readcolumn.ids")));
                if (jobConf.get("hoodie.read.columns.set") == null) {
                    HoodieParquetRealtimeInputFormat.cleanProjectionColumnIds((Configuration)jobConf);
                    HoodieParquetRealtimeInputFormat.addRequiredProjectionFields((Configuration)jobConf);
                    this.conf = jobConf;
                    this.conf.set("hoodie.read.columns.set", "true");
                }
            }
        }
        LOG.info((Object)("Creating record reader with readCols :" + jobConf.get("hive.io.file.readcolumn.names") + ", Ids :" + jobConf.get("hive.io.file.readcolumn.ids")));
        ValidationUtils.checkArgument(split instanceof RealtimeSplit, "HoodieRealtimeRecordReader can only work on RealtimeSplit and not with " + split);
        return new HoodieRealtimeRecordReader((RealtimeSplit)split, jobConf, super.getRecordReader(split, jobConf, reporter));
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }
}

