/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieDefaultTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.hadoop.FileStatusWithBootstrapBaseFile;
import org.apache.hudi.hadoop.HoodieParquetInputFormat;
import org.apache.hudi.hadoop.LocatedFileStatusWithBootstrapBaseFile;
import org.apache.hudi.hadoop.realtime.HoodieParquetRealtimeInputFormat;
import org.apache.hudi.hadoop.utils.HoodieHiveUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieInputFormatUtils {
    public static final int HOODIE_COMMIT_TIME_COL_POS = 0;
    public static final int HOODIE_RECORD_KEY_COL_POS = 2;
    public static final int HOODIE_PARTITION_PATH_COL_POS = 3;
    public static final String HOODIE_READ_COLUMNS_PROP = "hoodie.read.columns.set";
    private static final Logger LOG = LogManager.getLogger(HoodieInputFormatUtils.class);

    public static FileInputFormat getInputFormat(HoodieFileFormat baseFileFormat, boolean realtime, Configuration conf) {
        switch (baseFileFormat) {
            case PARQUET: {
                if (realtime) {
                    HoodieParquetRealtimeInputFormat inputFormat = new HoodieParquetRealtimeInputFormat();
                    inputFormat.setConf(conf);
                    return inputFormat;
                }
                HoodieParquetInputFormat inputFormat = new HoodieParquetInputFormat();
                inputFormat.setConf(conf);
                return inputFormat;
            }
        }
        throw new HoodieIOException("Hoodie InputFormat not implemented for base file format " + (Object)((Object)baseFileFormat));
    }

    public static String getInputFormatClassName(HoodieFileFormat baseFileFormat, boolean realtime, Configuration conf) {
        FileInputFormat inputFormat = HoodieInputFormatUtils.getInputFormat(baseFileFormat, realtime, conf);
        return inputFormat.getClass().getName();
    }

    public static String getOutputFormatClassName(HoodieFileFormat baseFileFormat) {
        switch (baseFileFormat) {
            case PARQUET: {
                return MapredParquetOutputFormat.class.getName();
            }
        }
        throw new HoodieIOException("No OutputFormat for base file format " + (Object)((Object)baseFileFormat));
    }

    public static String getSerDeClassName(HoodieFileFormat baseFileFormat) {
        switch (baseFileFormat) {
            case PARQUET: {
                return ParquetHiveSerDe.class.getName();
            }
        }
        throw new HoodieIOException("No SerDe for base file format " + (Object)((Object)baseFileFormat));
    }

    public static FileInputFormat getInputFormat(String path, boolean realtime, Configuration conf) {
        String extension = FSUtils.getFileExtension(path);
        if (extension.equals(HoodieFileFormat.PARQUET.getFileExtension())) {
            return HoodieInputFormatUtils.getInputFormat(HoodieFileFormat.PARQUET, realtime, conf);
        }
        throw new HoodieIOException("Hoodie InputFormat not implemented for base file of type " + extension);
    }

    public static HoodieDefaultTimeline filterInstantsTimeline(HoodieDefaultTimeline timeline) {
        HoodieDefaultTimeline commitsAndCompactionTimeline = timeline.getCommitsAndCompactionTimeline();
        Option<HoodieInstant> pendingCompactionInstant = commitsAndCompactionTimeline.filterPendingCompactionTimeline().firstInstant();
        if (pendingCompactionInstant.isPresent()) {
            HoodieDefaultTimeline instantsTimeline = commitsAndCompactionTimeline.findInstantsBefore(pendingCompactionInstant.get().getTimestamp());
            int numCommitsFilteredByCompaction = commitsAndCompactionTimeline.getCommitsTimeline().countInstants() - instantsTimeline.getCommitsTimeline().countInstants();
            LOG.info((Object)("Earliest pending compaction instant is: " + pendingCompactionInstant.get().getTimestamp() + " skipping " + numCommitsFilteredByCompaction + " commits"));
            return instantsTimeline;
        }
        return timeline;
    }

    public static Option<String> getAffectedPartitions(List<HoodieInstant> commitsToCheck, HoodieTableMetaClient tableMetaClient, HoodieTimeline timeline, List<Path> inputPaths) throws IOException {
        HashSet<String> partitionsToList = new HashSet<String>();
        for (HoodieInstant commit : commitsToCheck) {
            HoodieCommitMetadata commitMetadata = HoodieCommitMetadata.fromBytes(timeline.getInstantDetails(commit).get(), HoodieCommitMetadata.class);
            partitionsToList.addAll(commitMetadata.getPartitionToWriteStats().keySet());
        }
        if (partitionsToList.isEmpty()) {
            return Option.empty();
        }
        String incrementalInputPaths = partitionsToList.stream().map(s -> StringUtils.isNullOrEmpty(s) ? tableMetaClient.getBasePath() : tableMetaClient.getBasePath() + "/" + s).filter(s -> {
            for (Path path : inputPaths) {
                if (!path.toString().contains((CharSequence)s)) continue;
                return true;
            }
            return false;
        }).collect(Collectors.joining(","));
        return Option.of(incrementalInputPaths);
    }

    public static Option<HoodieTimeline> getFilteredCommitsTimeline(Job job, HoodieTableMetaClient tableMetaClient) {
        String tableName = tableMetaClient.getTableConfig().getTableName();
        HoodieDefaultTimeline baseTimeline = HoodieHiveUtils.stopAtCompaction((JobContext)job, tableName) ? HoodieInputFormatUtils.filterInstantsTimeline(tableMetaClient.getActiveTimeline()) : tableMetaClient.getActiveTimeline();
        return Option.of(baseTimeline.getCommitsTimeline().filterCompletedInstants());
    }

    public static Option<List<HoodieInstant>> getCommitsForIncrementalQuery(Job job, String tableName, HoodieTimeline timeline) {
        String lastIncrementalTs = HoodieHiveUtils.readStartCommitTime((JobContext)job, tableName);
        Integer maxCommits = HoodieHiveUtils.readMaxCommits((JobContext)job, tableName);
        LOG.info((Object)("Last Incremental timestamp was set as " + lastIncrementalTs));
        return Option.of(timeline.findInstantsAfter(lastIncrementalTs, maxCommits).getInstants().collect(Collectors.toList()));
    }

    public static Map<Path, HoodieTableMetaClient> getTableMetaClientByBasePath(Configuration conf, Set<Path> partitions) {
        HashMap metaClientMap = new HashMap();
        return partitions.stream().collect(Collectors.toMap(Function.identity(), p -> {
            Option<String> matchingBasePath = Option.fromJavaOptional(metaClientMap.keySet().stream().filter(basePath -> p.toString().startsWith((String)basePath)).findFirst());
            if (matchingBasePath.isPresent()) {
                return (HoodieTableMetaClient)metaClientMap.get(matchingBasePath.get());
            }
            try {
                HoodieTableMetaClient metaClient = HoodieInputFormatUtils.getTableMetaClientForBasePath(p.getFileSystem(conf), p);
                metaClientMap.put(metaClient.getBasePath(), metaClient);
                return metaClient;
            }
            catch (IOException e) {
                throw new HoodieIOException("Error creating hoodie meta client against : " + p, e);
            }
        }));
    }

    public static HoodieTableMetaClient getTableMetaClientForBasePath(FileSystem fs, Path dataPath) throws IOException {
        int levels = 3;
        if (HoodiePartitionMetadata.hasPartitionMetadata(fs, dataPath)) {
            HoodiePartitionMetadata metadata = new HoodiePartitionMetadata(fs, dataPath);
            metadata.readFromFS();
            levels = metadata.getPartitionDepth();
        }
        Path baseDir = HoodieHiveUtils.getNthParent(dataPath, levels);
        LOG.info((Object)("Reading hoodie metadata from path " + baseDir.toString()));
        return new HoodieTableMetaClient(fs.getConf(), baseDir.toString());
    }

    public static FileStatus getFileStatus(HoodieBaseFile baseFile) throws IOException {
        if (baseFile.getBootstrapBaseFile().isPresent()) {
            if (baseFile.getFileStatus() instanceof LocatedFileStatus) {
                return new LocatedFileStatusWithBootstrapBaseFile((LocatedFileStatus)baseFile.getFileStatus(), baseFile.getBootstrapBaseFile().get().getFileStatus());
            }
            return new FileStatusWithBootstrapBaseFile(baseFile.getFileStatus(), baseFile.getBootstrapBaseFile().get().getFileStatus());
        }
        return baseFile.getFileStatus();
    }

    public static List<FileStatus> filterIncrementalFileStatus(Job job, HoodieTableMetaClient tableMetaClient, HoodieTimeline timeline, FileStatus[] fileStatuses, List<HoodieInstant> commitsToCheck) throws IOException {
        HoodieTableFileSystemView roView = new HoodieTableFileSystemView(tableMetaClient, timeline, fileStatuses);
        List<String> commitsList = commitsToCheck.stream().map(HoodieInstant::getTimestamp).collect(Collectors.toList());
        List filteredFiles = roView.getLatestBaseFilesInRange(commitsList).collect(Collectors.toList());
        ArrayList<FileStatus> returns = new ArrayList<FileStatus>();
        for (HoodieBaseFile filteredFile : filteredFiles) {
            LOG.debug((Object)("Processing incremental hoodie file - " + filteredFile.getPath()));
            filteredFile = HoodieInputFormatUtils.refreshFileStatus(job.getConfiguration(), filteredFile);
            returns.add(HoodieInputFormatUtils.getFileStatus(filteredFile));
        }
        LOG.info((Object)("Total paths to process after hoodie incremental filter " + filteredFiles.size()));
        return returns;
    }

    public static Map<HoodieTableMetaClient, List<FileStatus>> groupFileStatusForSnapshotPaths(FileStatus[] fileStatuses, String fileExtension, Collection<HoodieTableMetaClient> metaClientList) {
        HashMap<HoodieTableMetaClient, List<FileStatus>> grouped = new HashMap<HoodieTableMetaClient, List<FileStatus>>();
        HoodieTableMetaClient metadata = null;
        for (FileStatus status : fileStatuses) {
            Path inputPath = status.getPath();
            if (!inputPath.getName().endsWith(fileExtension)) continue;
            if (metadata == null || !inputPath.toString().contains(metadata.getBasePath())) {
                for (HoodieTableMetaClient metaClient : metaClientList) {
                    if (!inputPath.toString().contains(metaClient.getBasePath())) continue;
                    metadata = metaClient;
                    if (grouped.containsKey(metadata)) break;
                    grouped.put(metadata, new ArrayList());
                    break;
                }
            }
            ((List)grouped.get(metadata)).add(status);
        }
        return grouped;
    }

    public static List<FileStatus> filterFileStatusForSnapshotMode(JobConf job, HoodieTableMetaClient metadata, List<FileStatus> fileStatuses) throws IOException {
        FileStatus[] statuses = fileStatuses.toArray(new FileStatus[0]);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Hoodie Metadata initialized with completed commit Ts as :" + metadata));
        }
        HoodieTimeline timeline = metadata.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
        HoodieTableFileSystemView roView = new HoodieTableFileSystemView(metadata, timeline, statuses);
        List filteredFiles = roView.getLatestBaseFiles().collect(Collectors.toList());
        LOG.info((Object)("Total paths to process after hoodie filter " + filteredFiles.size()));
        ArrayList<FileStatus> returns = new ArrayList<FileStatus>();
        for (HoodieBaseFile filteredFile : filteredFiles) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Processing latest hoodie file - " + filteredFile.getPath()));
            }
            filteredFile = HoodieInputFormatUtils.refreshFileStatus((Configuration)job, filteredFile);
            returns.add(HoodieInputFormatUtils.getFileStatus(filteredFile));
        }
        return returns;
    }

    private static HoodieBaseFile refreshFileStatus(Configuration conf, HoodieBaseFile dataFile) {
        Path dataPath = dataFile.getFileStatus().getPath();
        try {
            if (dataFile.getFileSize() == 0L) {
                FileSystem fs = dataPath.getFileSystem(conf);
                LOG.info((Object)("Refreshing file status " + dataFile.getPath()));
                return new HoodieBaseFile(fs.getFileStatus(dataPath), (BaseFile)dataFile.getBootstrapBaseFile().orElse(null));
            }
            return dataFile;
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not get FileStatus on path " + dataPath);
        }
    }
}

