/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieParquetReader;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;

public class HoodieFileReaderFactory {
    public static <T extends HoodieRecordPayload, R extends IndexedRecord> HoodieFileReader<R> getFileReader(Configuration conf, Path path) throws IOException {
        String extension = FSUtils.getFileExtension(path.toString());
        if (HoodieFileFormat.PARQUET.getFileExtension().equals(extension)) {
            return HoodieFileReaderFactory.newParquetFileReader(conf, path);
        }
        throw new UnsupportedOperationException(extension + " format not supported yet.");
    }

    private static <T extends HoodieRecordPayload, R extends IndexedRecord> HoodieFileReader<R> newParquetFileReader(Configuration conf, Path path) throws IOException {
        return new HoodieParquetReader(conf, path);
    }
}

