/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hudi.org.apache.hadoop.hbase.JitterScheduledThreadPoolExecutorImpl;
import org.apache.hudi.org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class ChoreService
implements ScheduledChore.ChoreServicer {
    private static final Log LOG = LogFactory.getLog(ChoreService.class);
    public static final int MIN_CORE_POOL_SIZE = 1;
    private final ScheduledThreadPoolExecutor scheduler;
    private final HashMap<ScheduledChore, ScheduledFuture<?>> scheduledChores;
    private final HashMap<ScheduledChore, Boolean> choresMissingStartTime;
    private final String coreThreadPoolPrefix;

    @VisibleForTesting
    public ChoreService(String coreThreadPoolPrefix) {
        this(coreThreadPoolPrefix, 1, false);
    }

    public ChoreService(String coreThreadPoolPrefix, boolean jitter) {
        this(coreThreadPoolPrefix, 1, jitter);
    }

    public ChoreService(String coreThreadPoolPrefix, int corePoolSize, boolean jitter) {
        this.coreThreadPoolPrefix = coreThreadPoolPrefix;
        if (corePoolSize < 1) {
            corePoolSize = 1;
        }
        ChoreServiceThreadFactory threadFactory = new ChoreServiceThreadFactory(coreThreadPoolPrefix);
        this.scheduler = jitter ? new JitterScheduledThreadPoolExecutorImpl(corePoolSize, (ThreadFactory)threadFactory, 0.1) : new ScheduledThreadPoolExecutor(corePoolSize, threadFactory);
        this.scheduler.setRemoveOnCancelPolicy(true);
        this.scheduledChores = new HashMap();
        this.choresMissingStartTime = new HashMap();
    }

    public static ChoreService getInstance(String coreThreadPoolPrefix) {
        return new ChoreService(coreThreadPoolPrefix);
    }

    public synchronized boolean scheduleChore(ScheduledChore chore) {
        if (chore == null) {
            return false;
        }
        try {
            chore.setChoreServicer(this);
            ScheduledFuture<?> future = this.scheduler.scheduleAtFixedRate(chore, chore.getInitialDelay(), chore.getPeriod(), chore.getTimeUnit());
            this.scheduledChores.put(chore, future);
            return true;
        }
        catch (Exception exception) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Could not successfully schedule chore: " + chore.getName()));
            }
            return false;
        }
    }

    private synchronized void rescheduleChore(ScheduledChore chore) {
        if (chore == null) {
            return;
        }
        if (this.scheduledChores.containsKey(chore)) {
            ScheduledFuture<?> future = this.scheduledChores.get(chore);
            future.cancel(false);
        }
        this.scheduleChore(chore);
    }

    @Override
    public synchronized void cancelChore(ScheduledChore chore) {
        this.cancelChore(chore, true);
    }

    @Override
    public synchronized void cancelChore(ScheduledChore chore, boolean mayInterruptIfRunning) {
        if (chore != null && this.scheduledChores.containsKey(chore)) {
            ScheduledFuture<?> future = this.scheduledChores.get(chore);
            future.cancel(mayInterruptIfRunning);
            this.scheduledChores.remove(chore);
            if (this.choresMissingStartTime.containsKey(chore)) {
                this.choresMissingStartTime.remove(chore);
                this.requestCorePoolDecrease();
            }
        }
    }

    @Override
    public synchronized boolean isChoreScheduled(ScheduledChore chore) {
        return chore != null && this.scheduledChores.containsKey(chore) && !this.scheduledChores.get(chore).isDone();
    }

    @Override
    public synchronized boolean triggerNow(ScheduledChore chore) {
        if (chore == null) {
            return false;
        }
        this.rescheduleChore(chore);
        return true;
    }

    int getNumberOfScheduledChores() {
        return this.scheduledChores.size();
    }

    int getNumberOfChoresMissingStartTime() {
        return this.choresMissingStartTime.size();
    }

    int getCorePoolSize() {
        return this.scheduler.getCorePoolSize();
    }

    private synchronized boolean requestCorePoolIncrease() {
        if (this.scheduler.getCorePoolSize() < this.scheduledChores.size()) {
            this.scheduler.setCorePoolSize(this.scheduler.getCorePoolSize() + 1);
            this.printChoreServiceDetails("requestCorePoolIncrease");
            return true;
        }
        return false;
    }

    private synchronized void requestCorePoolDecrease() {
        if (this.scheduler.getCorePoolSize() > 1) {
            this.scheduler.setCorePoolSize(this.scheduler.getCorePoolSize() - 1);
            this.printChoreServiceDetails("requestCorePoolDecrease");
        }
    }

    @Override
    public synchronized void onChoreMissedStartTime(ScheduledChore chore) {
        if (chore == null || !this.scheduledChores.containsKey(chore)) {
            return;
        }
        if (!this.choresMissingStartTime.containsKey(chore) || !this.choresMissingStartTime.get(chore).booleanValue()) {
            this.choresMissingStartTime.put(chore, this.requestCorePoolIncrease());
        }
        this.rescheduleChore(chore);
        this.printChoreDetails("onChoreMissedStartTime", chore);
    }

    public synchronized void shutdown() {
        this.scheduler.shutdownNow();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Chore service for: " + this.coreThreadPoolPrefix + " had " + this.scheduledChores.keySet() + " on shutdown"));
        }
        this.cancelAllChores(true);
        this.scheduledChores.clear();
        this.choresMissingStartTime.clear();
    }

    public boolean isShutdown() {
        return this.scheduler.isShutdown();
    }

    public boolean isTerminated() {
        return this.scheduler.isTerminated();
    }

    private void cancelAllChores(boolean mayInterruptIfRunning) {
        ArrayList<ScheduledChore> choresToCancel = new ArrayList<ScheduledChore>();
        for (ScheduledChore chore : this.scheduledChores.keySet()) {
            choresToCancel.add(chore);
        }
        for (ScheduledChore chore : choresToCancel) {
            this.cancelChore(chore, mayInterruptIfRunning);
        }
        choresToCancel.clear();
    }

    private void printChoreDetails(String header, ScheduledChore chore) {
        LinkedHashMap<String, String> output = new LinkedHashMap<String, String>();
        output.put(header, "");
        output.put("Chore name: ", chore.getName());
        output.put("Chore period: ", Integer.toString(chore.getPeriod()));
        output.put("Chore timeBetweenRuns: ", Long.toString(chore.getTimeBetweenRuns()));
        for (Map.Entry entry : output.entrySet()) {
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace((Object)((String)entry.getKey() + (String)entry.getValue()));
        }
    }

    private void printChoreServiceDetails(String header) {
        LinkedHashMap<String, String> output = new LinkedHashMap<String, String>();
        output.put(header, "");
        output.put("ChoreService corePoolSize: ", Integer.toString(this.getCorePoolSize()));
        output.put("ChoreService scheduledChores: ", Integer.toString(this.getNumberOfScheduledChores()));
        output.put("ChoreService missingStartTimeCount: ", Integer.toString(this.getNumberOfChoresMissingStartTime()));
        for (Map.Entry entry : output.entrySet()) {
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace((Object)((String)entry.getKey() + (String)entry.getValue()));
        }
    }

    static class ChoreServiceThreadFactory
    implements ThreadFactory {
        private final String threadPrefix;
        private static final String THREAD_NAME_SUFFIX = "_ChoreService_";
        private AtomicInteger threadNumber = new AtomicInteger(1);

        public ChoreServiceThreadFactory(String threadPrefix) {
            this.threadPrefix = threadPrefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, this.threadPrefix + THREAD_NAME_SUFFIX + this.threadNumber.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    }
}

