/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.HConstants;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hudi.org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hudi.org.apache.hadoop.hbase.RegionLocations;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.client.Connection;
import org.apache.hudi.org.apache.hadoop.hbase.client.Consistency;
import org.apache.hudi.org.apache.hadoop.hbase.client.HTable;
import org.apache.hudi.org.apache.hadoop.hbase.client.Result;
import org.apache.hudi.org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hudi.org.apache.hadoop.hbase.client.Scan;
import org.apache.hudi.org.apache.hadoop.hbase.client.Table;
import org.apache.hudi.org.apache.hadoop.hbase.client.UnmodifyableHRegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.ExceptionUtil;

@InterfaceAudience.Private
public class MetaScanner {
    private static final Log LOG = LogFactory.getLog(MetaScanner.class);

    @VisibleForTesting
    public static void metaScan(Connection connection, MetaScannerVisitor visitor) throws IOException {
        MetaScanner.metaScan(connection, visitor, null, null, Integer.MAX_VALUE);
    }

    public static void metaScan(Connection connection, MetaScannerVisitor visitor, TableName userTableName) throws IOException {
        MetaScanner.metaScan(connection, visitor, userTableName, null, Integer.MAX_VALUE, TableName.META_TABLE_NAME);
    }

    @VisibleForTesting
    public static void metaScan(Connection connection, MetaScannerVisitor visitor, TableName userTableName, byte[] row, int rowLimit) throws IOException {
        MetaScanner.metaScan(connection, visitor, userTableName, row, rowLimit, TableName.META_TABLE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void metaScan(Connection connection, MetaScannerVisitor visitor, TableName tableName, byte[] row, int rowLimit, TableName metaTableName) throws IOException {
        int rowUpperLimit = rowLimit > 0 ? rowLimit : Integer.MAX_VALUE;
        try (HTable metaTable = new HTable(TableName.META_TABLE_NAME, connection, null);){
            byte[] startRow;
            if (row != null) {
                Result startRowResult = MetaScanner.getClosestRowOrBefore(metaTable, tableName, row, connection.getConfiguration().getBoolean("hbase.meta.replicas.use", false));
                if (startRowResult == null) {
                    throw new TableNotFoundException("Cannot find row in " + metaTable.getName() + " for table: " + tableName + ", row=" + Bytes.toStringBinary(row));
                }
                HRegionInfo regionInfo = MetaScanner.getHRegionInfo(startRowResult);
                if (regionInfo == null) {
                    throw new IOException("HRegionInfo was null or empty in Meta for " + tableName + ", row=" + Bytes.toStringBinary(row));
                }
                byte[] rowBefore = regionInfo.getStartKey();
                startRow = HRegionInfo.createRegionName(tableName, rowBefore, "00000000000000", false);
            } else {
                startRow = tableName == null || tableName.getName().length == 0 ? HConstants.EMPTY_START_ROW : HRegionInfo.createRegionName(tableName, HConstants.EMPTY_START_ROW, "00000000000000", false);
            }
            Scan scan = new Scan(startRow).addFamily(HConstants.CATALOG_FAMILY);
            int scannerCaching = connection.getConfiguration().getInt("hbase.meta.scanner.caching", 100);
            if (connection.getConfiguration().getBoolean("hbase.meta.replicas.use", false)) {
                scan.setConsistency(Consistency.TIMELINE);
            }
            if (rowUpperLimit <= scannerCaching) {
                scan.setSmall(true);
            }
            int rows = Math.min(rowLimit, scannerCaching);
            scan.setCaching(rows);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Scanning " + metaTableName.getNameAsString() + " starting at row=" + Bytes.toStringBinary(startRow) + " for max=" + rowUpperLimit + " with caching=" + rows));
            }
            try (ResultScanner resultScanner = metaTable.getScanner(scan);){
                Result result;
                int processedRows = 0;
                while ((result = resultScanner.next()) != null) {
                    if (visitor != null && !visitor.processRow(result)) {
                    } else if (++processedRows < rowUpperLimit) continue;
                    break;
                }
            }
        }
        finally {
            if (visitor != null) {
                try {
                    visitor.close();
                }
                catch (Throwable t) {
                    ExceptionUtil.rethrowIfInterrupt(t);
                    LOG.debug((Object)"Got exception in closing the meta scanner visitor", t);
                }
            }
        }
    }

    private static Result getClosestRowOrBefore(Table metaTable, TableName userTableName, byte[] row, boolean useMetaReplicas) throws IOException {
        byte[] searchRow = HRegionInfo.createRegionName(userTableName, row, "99999999999999", false);
        Scan scan = Scan.createGetClosestRowOrBeforeReverseScan(searchRow);
        if (useMetaReplicas) {
            scan.setConsistency(Consistency.TIMELINE);
        }
        try (ResultScanner resultScanner = metaTable.getScanner(scan);){
            Result result = resultScanner.next();
            return result;
        }
    }

    @Deprecated
    public static HRegionInfo getHRegionInfo(Result data) {
        return HRegionInfo.getHRegionInfo(data);
    }

    @VisibleForTesting
    public static List<HRegionInfo> listAllRegions(Configuration conf, Connection connection, final boolean offlined) throws IOException {
        final ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>();
        MetaScannerVisitorBase visitor = new MetaScannerVisitorBase(){

            @Override
            public boolean processRow(Result result) throws IOException {
                if (result == null || result.isEmpty()) {
                    return true;
                }
                RegionLocations locations = MetaTableAccessor.getRegionLocations(result);
                if (locations == null) {
                    return true;
                }
                for (HRegionLocation loc : locations.getRegionLocations()) {
                    HRegionInfo regionInfo;
                    if (loc == null || (regionInfo = loc.getRegionInfo()).isOffline() && !offlined) continue;
                    regions.add(regionInfo);
                }
                return true;
            }
        };
        MetaScanner.metaScan(connection, visitor);
        return regions;
    }

    @Deprecated
    public static NavigableMap<HRegionInfo, ServerName> allTableRegions(Configuration conf, Connection connection, TableName tableName, boolean offlined) throws IOException {
        return MetaScanner.allTableRegions(connection, tableName);
    }

    public static NavigableMap<HRegionInfo, ServerName> allTableRegions(Connection connection, TableName tableName) throws IOException {
        final TreeMap<HRegionInfo, ServerName> regions = new TreeMap<HRegionInfo, ServerName>();
        TableMetaScannerVisitor visitor = new TableMetaScannerVisitor(tableName){

            @Override
            public boolean processRowInternal(Result result) throws IOException {
                RegionLocations locations = MetaTableAccessor.getRegionLocations(result);
                if (locations == null) {
                    return true;
                }
                for (HRegionLocation loc : locations.getRegionLocations()) {
                    if (loc == null) continue;
                    HRegionInfo regionInfo = loc.getRegionInfo();
                    regions.put(new UnmodifyableHRegionInfo(regionInfo), loc.getServerName());
                }
                return true;
            }
        };
        MetaScanner.metaScan(connection, visitor, tableName);
        return regions;
    }

    public static List<RegionLocations> listTableRegionLocations(Configuration conf, Connection connection, TableName tableName) throws IOException {
        final ArrayList<RegionLocations> regions = new ArrayList<RegionLocations>();
        TableMetaScannerVisitor visitor = new TableMetaScannerVisitor(tableName){

            @Override
            public boolean processRowInternal(Result result) throws IOException {
                RegionLocations locations = MetaTableAccessor.getRegionLocations(result);
                if (locations == null) {
                    return true;
                }
                regions.add(locations);
                return true;
            }
        };
        MetaScanner.metaScan(connection, visitor, tableName);
        return regions;
    }

    public static abstract class TableMetaScannerVisitor
    extends DefaultMetaScannerVisitor {
        private TableName tableName;

        public TableMetaScannerVisitor(TableName tableName) {
            this.tableName = tableName;
        }

        @Override
        public final boolean processRow(Result rowResult) throws IOException {
            HRegionInfo info = MetaScanner.getHRegionInfo(rowResult);
            if (info == null) {
                return true;
            }
            if (!info.getTable().equals(this.tableName)) {
                return false;
            }
            return super.processRow(rowResult);
        }
    }

    public static abstract class DefaultMetaScannerVisitor
    extends MetaScannerVisitorBase {
        public abstract boolean processRowInternal(Result var1) throws IOException;

        @Override
        public boolean processRow(Result rowResult) throws IOException {
            HRegionInfo info = MetaScanner.getHRegionInfo(rowResult);
            if (info == null) {
                return true;
            }
            if (!info.isOffline() && !info.isSplit()) {
                return this.processRowInternal(rowResult);
            }
            return true;
        }
    }

    public static abstract class MetaScannerVisitorBase
    implements MetaScannerVisitor {
        @Override
        public void close() throws IOException {
        }
    }

    public static interface MetaScannerVisitor
    extends Closeable {
        public boolean processRow(Result var1) throws IOException;
    }
}

