/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import org.apache.hudi.org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.client.Result;
import org.apache.hudi.org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.ClientProtos;

@InterfaceAudience.Private
public final class ResultStatsUtil {
    private ResultStatsUtil() {
    }

    public static <T> T updateStats(T r, ServerStatisticTracker serverStats, ServerName server, byte[] regionName) {
        if (!(r instanceof Result)) {
            return r;
        }
        Result result = (Result)r;
        ClientProtos.RegionLoadStats stats = result.getStats();
        if (stats == null) {
            return r;
        }
        if (regionName != null) {
            serverStats.updateRegionStats(server, regionName, stats);
        }
        return r;
    }

    public static <T> T updateStats(T r, ServerStatisticTracker stats, HRegionLocation regionLocation) {
        byte[] regionName = null;
        ServerName server = null;
        if (regionLocation != null) {
            server = regionLocation.getServerName();
            regionName = regionLocation.getRegionInfo().getRegionName();
        }
        return ResultStatsUtil.updateStats(r, stats, server, regionName);
    }
}

