/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client.metrics;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ServerSideScanMetrics {
    private final Map<String, AtomicLong> counters = new HashMap<String, AtomicLong>();
    public static final String COUNT_OF_ROWS_SCANNED_KEY = "ROWS_SCANNED";
    public static final String COUNT_OF_ROWS_FILTERED_KEY = "ROWS_FILTERED";
    public final AtomicLong countOfRowsFiltered = this.createCounter("ROWS_FILTERED");
    public final AtomicLong countOfRowsScanned = this.createCounter("ROWS_SCANNED");

    protected AtomicLong createCounter(String counterName) {
        AtomicLong c = new AtomicLong(0L);
        this.counters.put(counterName, c);
        return c;
    }

    public void setCounter(String counterName, long value) {
        AtomicLong c = this.counters.get(counterName);
        if (c != null) {
            c.set(value);
        }
    }

    public boolean hasCounter(String counterName) {
        return this.counters.containsKey(counterName);
    }

    public AtomicLong getCounter(String counterName) {
        return this.counters.get(counterName);
    }

    public void addToCounter(String counterName, long delta) {
        AtomicLong c = this.counters.get(counterName);
        if (c != null) {
            c.addAndGet(delta);
        }
    }

    public Map<String, Long> getMetricsMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, AtomicLong> e : this.counters.entrySet()) {
            builder.put((Object)e.getKey(), (Object)e.getValue().getAndSet(0L));
        }
        return builder.build();
    }
}

