/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.io.hfile;

import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hudi.org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hudi.org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hudi.org.apache.hadoop.hbase.util.ChecksumType;

@InterfaceAudience.Private
public class HFileContextBuilder {
    public static final int DEFAULT_BYTES_PER_CHECKSUM = 16384;
    private boolean usesHBaseChecksum = true;
    private boolean includesMvcc = true;
    private boolean includesTags = false;
    private Compression.Algorithm compression = Compression.Algorithm.NONE;
    private boolean compressTags = false;
    private ChecksumType checksumType = ChecksumType.getDefaultChecksumType();
    private int bytesPerChecksum = 16384;
    private int blocksize = 65536;
    private DataBlockEncoding encoding = DataBlockEncoding.NONE;
    private Encryption.Context cryptoContext = Encryption.Context.NONE;
    private long fileCreateTime = 0L;

    public HFileContextBuilder withHBaseCheckSum(boolean useHBaseCheckSum) {
        this.usesHBaseChecksum = useHBaseCheckSum;
        return this;
    }

    public HFileContextBuilder withIncludesMvcc(boolean includesMvcc) {
        this.includesMvcc = includesMvcc;
        return this;
    }

    public HFileContextBuilder withIncludesTags(boolean includesTags) {
        this.includesTags = includesTags;
        return this;
    }

    public HFileContextBuilder withCompression(Compression.Algorithm compression) {
        this.compression = compression;
        return this;
    }

    public HFileContextBuilder withCompressTags(boolean compressTags) {
        this.compressTags = compressTags;
        return this;
    }

    public HFileContextBuilder withChecksumType(ChecksumType checkSumType) {
        this.checksumType = checkSumType;
        return this;
    }

    public HFileContextBuilder withBytesPerCheckSum(int bytesPerChecksum) {
        this.bytesPerChecksum = bytesPerChecksum;
        return this;
    }

    public HFileContextBuilder withBlockSize(int blockSize) {
        this.blocksize = blockSize;
        return this;
    }

    public HFileContextBuilder withDataBlockEncoding(DataBlockEncoding encoding) {
        this.encoding = encoding;
        return this;
    }

    public HFileContextBuilder withEncryptionContext(Encryption.Context cryptoContext) {
        this.cryptoContext = cryptoContext;
        return this;
    }

    public HFileContextBuilder withCreateTime(long fileCreateTime) {
        this.fileCreateTime = fileCreateTime;
        return this;
    }

    public HFileContext build() {
        return new HFileContext(this.usesHBaseChecksum, this.includesMvcc, this.includesTags, this.compression, this.compressTags, this.checksumType, this.bytesPerChecksum, this.blocksize, this.encoding, this.cryptoContext, this.fileCreateTime);
    }
}

