/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.io.hfile;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hudi.org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.BlockCacheUtil;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.BlockPriority;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CachedBlock;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.LruCachedBlock;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.LruCachedBlockQueue;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.ResizableBlockCache;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hudi.org.apache.hadoop.hbase.util.HasThread;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@InterfaceAudience.Private
@JsonIgnoreProperties(value={"encodingCountsForTest"})
public class LruBlockCache
implements ResizableBlockCache,
HeapSize {
    private static final Log LOG = LogFactory.getLog(LruBlockCache.class);
    static final String LRU_MIN_FACTOR_CONFIG_NAME = "hbase.lru.blockcache.min.factor";
    static final String LRU_ACCEPTABLE_FACTOR_CONFIG_NAME = "hbase.lru.blockcache.acceptable.factor";
    static final String LRU_HARD_CAPACITY_LIMIT_FACTOR_CONFIG_NAME = "hbase.lru.blockcache.hard.capacity.limit.factor";
    static final String LRU_SINGLE_PERCENTAGE_CONFIG_NAME = "hbase.lru.blockcache.single.percentage";
    static final String LRU_MULTI_PERCENTAGE_CONFIG_NAME = "hbase.lru.blockcache.multi.percentage";
    static final String LRU_MEMORY_PERCENTAGE_CONFIG_NAME = "hbase.lru.blockcache.memory.percentage";
    static final String LRU_IN_MEMORY_FORCE_MODE_CONFIG_NAME = "hbase.lru.rs.inmemoryforcemode";
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    static final float DEFAULT_MIN_FACTOR = 0.95f;
    static final float DEFAULT_ACCEPTABLE_FACTOR = 0.99f;
    static final float DEFAULT_SINGLE_FACTOR = 0.25f;
    static final float DEFAULT_MULTI_FACTOR = 0.5f;
    static final float DEFAULT_MEMORY_FACTOR = 0.25f;
    static final float DEFAULT_HARD_CAPACITY_LIMIT_FACTOR = 1.2f;
    static final boolean DEFAULT_IN_MEMORY_FORCE_MODE = false;
    static final int statThreadPeriod = 300;
    private static final String LRU_MAX_BLOCK_SIZE = "hbase.lru.max.block.size";
    private static final long DEFAULT_MAX_BLOCK_SIZE = 0x1000000L;
    private final Map<BlockCacheKey, LruCachedBlock> map;
    private final ReentrantLock evictionLock = new ReentrantLock(true);
    private final long maxBlockSize;
    private volatile boolean evictionInProgress = false;
    private final EvictionThread evictionThread;
    private final ScheduledExecutorService scheduleThreadPool = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("LruBlockCacheStatsExecutor").setDaemon(true).build());
    private final AtomicLong size;
    private final AtomicLong elements;
    private final AtomicLong count;
    private float hardCapacityLimitFactor;
    private final CacheStats stats;
    private long maxSize;
    private long blockSize;
    private float acceptableFactor;
    private float minFactor;
    private float singleFactor;
    private float multiFactor;
    private float memoryFactor;
    private long overhead;
    private boolean forceInMemory;
    private BlockCache victimHandler = null;
    public static final long CACHE_FIXED_OVERHEAD = ClassSize.align(32 + 9 * ClassSize.REFERENCE + 24 + 2 + ClassSize.OBJECT);

    public LruBlockCache(long maxSize, long blockSize) {
        this(maxSize, blockSize, true);
    }

    public LruBlockCache(long maxSize, long blockSize, boolean evictionThread) {
        this(maxSize, blockSize, evictionThread, (int)Math.ceil(1.2 * (double)maxSize / (double)blockSize), 0.75f, 16, 0.95f, 0.99f, 0.25f, 0.5f, 0.25f, 1.2f, false, 0x1000000L);
    }

    public LruBlockCache(long maxSize, long blockSize, boolean evictionThread, Configuration conf) {
        this(maxSize, blockSize, evictionThread, (int)Math.ceil(1.2 * (double)maxSize / (double)blockSize), 0.75f, 16, conf.getFloat(LRU_MIN_FACTOR_CONFIG_NAME, 0.95f), conf.getFloat(LRU_ACCEPTABLE_FACTOR_CONFIG_NAME, 0.99f), conf.getFloat(LRU_SINGLE_PERCENTAGE_CONFIG_NAME, 0.25f), conf.getFloat(LRU_MULTI_PERCENTAGE_CONFIG_NAME, 0.5f), conf.getFloat(LRU_MEMORY_PERCENTAGE_CONFIG_NAME, 0.25f), conf.getFloat(LRU_HARD_CAPACITY_LIMIT_FACTOR_CONFIG_NAME, 1.2f), conf.getBoolean(LRU_IN_MEMORY_FORCE_MODE_CONFIG_NAME, false), conf.getLong(LRU_MAX_BLOCK_SIZE, 0x1000000L));
    }

    public LruBlockCache(long maxSize, long blockSize, Configuration conf) {
        this(maxSize, blockSize, true, conf);
    }

    public LruBlockCache(long maxSize, long blockSize, boolean evictionThread, int mapInitialSize, float mapLoadFactor, int mapConcurrencyLevel, float minFactor, float acceptableFactor, float singleFactor, float multiFactor, float memoryFactor, float hardLimitFactor, boolean forceInMemory, long maxBlockSize) {
        this.maxBlockSize = maxBlockSize;
        if (singleFactor + multiFactor + memoryFactor != 1.0f || singleFactor < 0.0f || multiFactor < 0.0f || memoryFactor < 0.0f) {
            throw new IllegalArgumentException("Single, multi, and memory factors  should be non-negative and total 1.0");
        }
        if (minFactor >= acceptableFactor) {
            throw new IllegalArgumentException("minFactor must be smaller than acceptableFactor");
        }
        if (minFactor >= 1.0f || acceptableFactor >= 1.0f) {
            throw new IllegalArgumentException("all factors must be < 1");
        }
        this.maxSize = maxSize;
        this.blockSize = blockSize;
        this.forceInMemory = forceInMemory;
        this.map = new ConcurrentHashMap<BlockCacheKey, LruCachedBlock>(mapInitialSize, mapLoadFactor, mapConcurrencyLevel);
        this.minFactor = minFactor;
        this.acceptableFactor = acceptableFactor;
        this.singleFactor = singleFactor;
        this.multiFactor = multiFactor;
        this.memoryFactor = memoryFactor;
        this.stats = new CacheStats(this.getClass().getSimpleName());
        this.count = new AtomicLong(0L);
        this.elements = new AtomicLong(0L);
        this.overhead = LruBlockCache.calculateOverhead(maxSize, blockSize, mapConcurrencyLevel);
        this.size = new AtomicLong(this.overhead);
        this.hardCapacityLimitFactor = hardLimitFactor;
        if (evictionThread) {
            this.evictionThread = new EvictionThread(this);
            this.evictionThread.start();
        } else {
            this.evictionThread = null;
        }
        this.scheduleThreadPool.scheduleAtFixedRate(new StatisticsThread(this), 300L, 300L, TimeUnit.SECONDS);
    }

    @Override
    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
        if (this.size.get() > this.acceptableSize() && !this.evictionInProgress) {
            this.runEviction();
        }
    }

    @Override
    public void cacheBlock(BlockCacheKey cacheKey, Cacheable buf, boolean inMemory, boolean cacheDataInL1) {
        long currentAcceptableSize;
        long hardLimitSize;
        if (buf.heapSize() > this.maxBlockSize) {
            if (this.stats.failInsert() % 50L == 0L) {
                LOG.warn((Object)("Trying to cache too large a block " + cacheKey.getHfileName() + " @ " + cacheKey.getOffset() + " is " + buf.heapSize() + " which is larger than " + this.maxBlockSize));
            }
            return;
        }
        LruCachedBlock cb = this.map.get(cacheKey);
        if (cb != null) {
            if (this.compare(buf, cb.getBuffer()) != 0) {
                throw new RuntimeException("Cached block contents differ, which should not have happened.cacheKey:" + cacheKey);
            }
            String msg = "Cached an already cached block: " + cacheKey + " cb:" + cb.getCacheKey();
            msg = msg + ". This is harmless and can happen in rare cases (see HBASE-8547)";
            LOG.warn((Object)msg);
            return;
        }
        long currentSize = this.size.get();
        if (currentSize >= (hardLimitSize = (long)(this.hardCapacityLimitFactor * (float)(currentAcceptableSize = this.acceptableSize())))) {
            this.stats.failInsert();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("LruBlockCache current size " + StringUtils.byteDesc((long)currentSize) + " has exceeded acceptable size " + StringUtils.byteDesc((long)currentAcceptableSize) + "  too many." + " the hard limit size is " + StringUtils.byteDesc((long)hardLimitSize) + ", failed to put cacheKey:" + cacheKey + " into LruBlockCache."));
            }
            if (!this.evictionInProgress) {
                this.runEviction();
            }
            return;
        }
        cb = new LruCachedBlock(cacheKey, buf, this.count.incrementAndGet(), inMemory);
        long newSize = this.updateSizeMetrics(cb, false);
        this.map.put(cacheKey, cb);
        long val = this.elements.incrementAndGet();
        if (LOG.isTraceEnabled()) {
            long size = this.map.size();
            LruBlockCache.assertCounterSanity(size, val);
        }
        if (newSize > currentAcceptableSize && !this.evictionInProgress) {
            this.runEviction();
        }
    }

    private static void assertCounterSanity(long mapSize, long counterVal) {
        double pct_diff;
        if (counterVal < 0L) {
            LOG.trace((Object)("counterVal overflow. Assertions unreliable. counterVal=" + counterVal + ", mapSize=" + mapSize));
            return;
        }
        if (mapSize < Integer.MAX_VALUE && (pct_diff = Math.abs((double)counterVal / (double)mapSize - 1.0)) > 0.05) {
            LOG.trace((Object)("delta between reported and actual size > 5%. counterVal=" + counterVal + ", mapSize=" + mapSize));
        }
    }

    private int compare(Cacheable left, Cacheable right) {
        ByteBuffer l = ByteBuffer.allocate(left.getSerializedLength());
        left.serialize(l);
        ByteBuffer r = ByteBuffer.allocate(right.getSerializedLength());
        right.serialize(r);
        return Bytes.compareTo(l.array(), l.arrayOffset(), l.limit(), r.array(), r.arrayOffset(), r.limit());
    }

    @Override
    public void cacheBlock(BlockCacheKey cacheKey, Cacheable buf) {
        this.cacheBlock(cacheKey, buf, false, false);
    }

    protected long updateSizeMetrics(LruCachedBlock cb, boolean evict) {
        long heapsize = cb.heapSize();
        if (evict) {
            heapsize *= -1L;
        }
        return this.size.addAndGet(heapsize);
    }

    @Override
    public Cacheable getBlock(BlockCacheKey cacheKey, boolean caching, boolean repeat, boolean updateCacheMetrics) {
        LruCachedBlock cb = this.map.get(cacheKey);
        if (cb == null) {
            if (!repeat && updateCacheMetrics) {
                this.stats.miss(caching, cacheKey.isPrimary());
            }
            if (this.victimHandler != null && !repeat) {
                Cacheable result = this.victimHandler.getBlock(cacheKey, caching, repeat, updateCacheMetrics);
                if (result != null && caching) {
                    this.cacheBlock(cacheKey, result, false, true);
                }
                return result;
            }
            return null;
        }
        if (updateCacheMetrics) {
            this.stats.hit(caching, cacheKey.isPrimary());
        }
        cb.access(this.count.incrementAndGet());
        return cb.getBuffer();
    }

    public boolean containsBlock(BlockCacheKey cacheKey) {
        return this.map.containsKey(cacheKey);
    }

    @Override
    public boolean evictBlock(BlockCacheKey cacheKey) {
        LruCachedBlock cb = this.map.get(cacheKey);
        if (cb == null) {
            return false;
        }
        this.evictBlock(cb, false);
        return true;
    }

    @Override
    public int evictBlocksByHfileName(String hfileName) {
        int numEvicted = 0;
        for (BlockCacheKey key : this.map.keySet()) {
            if (!key.getHfileName().equals(hfileName) || !this.evictBlock(key)) continue;
            ++numEvicted;
        }
        if (this.victimHandler != null) {
            numEvicted += this.victimHandler.evictBlocksByHfileName(hfileName);
        }
        return numEvicted;
    }

    protected long evictBlock(LruCachedBlock block, boolean evictedByEvictionProcess) {
        this.map.remove(block.getCacheKey());
        this.updateSizeMetrics(block, true);
        long val = this.elements.decrementAndGet();
        if (LOG.isTraceEnabled()) {
            long size = this.map.size();
            LruBlockCache.assertCounterSanity(size, val);
        }
        this.stats.evicted(block.getCachedTime(), block.getCacheKey().isPrimary());
        if (evictedByEvictionProcess && this.victimHandler != null) {
            if (this.victimHandler instanceof BucketCache) {
                boolean wait = this.getCurrentSize() < this.acceptableSize();
                boolean inMemory = block.getPriority() == BlockPriority.MEMORY;
                ((BucketCache)this.victimHandler).cacheBlockWithWait(block.getCacheKey(), block.getBuffer(), inMemory, wait);
            } else {
                this.victimHandler.cacheBlock(block.getCacheKey(), block.getBuffer());
            }
        }
        return block.heapSize();
    }

    private void runEviction() {
        if (this.evictionThread == null) {
            this.evict();
        } else {
            this.evictionThread.evict();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void evict() {
        if (!this.evictionLock.tryLock()) {
            return;
        }
        try {
            long bytesFreed;
            BlockBucket bucketMemory;
            BlockBucket bucketMulti;
            BlockBucket bucketSingle;
            block21: {
                BlockBucket bucket;
                long bytesToFree;
                block19: {
                    long bytesRemain;
                    long s;
                    block23: {
                        long m;
                        block22: {
                            block20: {
                                this.evictionInProgress = true;
                                long currentSize = this.size.get();
                                bytesToFree = currentSize - this.minSize();
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace((Object)("Block cache LRU eviction started; Attempting to free " + StringUtils.byteDesc((long)bytesToFree) + " of total=" + StringUtils.byteDesc((long)currentSize)));
                                }
                                if (bytesToFree <= 0L) {
                                    return;
                                }
                                bucketSingle = new BlockBucket("single", bytesToFree, this.blockSize, this.singleSize());
                                bucketMulti = new BlockBucket("multi", bytesToFree, this.blockSize, this.multiSize());
                                bucketMemory = new BlockBucket("memory", bytesToFree, this.blockSize, this.memorySize());
                                for (LruCachedBlock cachedBlock : this.map.values()) {
                                    switch (cachedBlock.getPriority()) {
                                        case SINGLE: {
                                            bucketSingle.add(cachedBlock);
                                            break;
                                        }
                                        case MULTI: {
                                            bucketMulti.add(cachedBlock);
                                            break;
                                        }
                                        case MEMORY: {
                                            bucketMemory.add(cachedBlock);
                                        }
                                    }
                                }
                                bytesFreed = 0L;
                                if (!this.forceInMemory && !(this.memoryFactor > 0.999f)) break block19;
                                s = bucketSingle.totalSize();
                                if (bytesToFree <= s + (m = bucketMulti.totalSize())) break block20;
                                bytesFreed = bucketSingle.free(s);
                                bytesFreed += bucketMulti.free(m);
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace((Object)("freed " + StringUtils.byteDesc((long)bytesFreed) + " from single and multi buckets"));
                                }
                                bytesFreed += bucketMemory.free(bytesToFree - bytesFreed);
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace((Object)("freed " + StringUtils.byteDesc((long)bytesFreed) + " total from all three buckets "));
                                }
                                break block21;
                            }
                            bytesRemain = s + m - bytesToFree;
                            if (3L * s > bytesRemain) break block22;
                            bytesFreed = bucketMulti.free(bytesToFree);
                            break block21;
                        }
                        if (3L * m > 2L * bytesRemain) break block23;
                        bytesFreed = bucketSingle.free(bytesToFree);
                        break block21;
                    }
                    bytesFreed = bucketSingle.free(s - bytesRemain / 3L);
                    if (bytesFreed >= bytesToFree) break block21;
                    bytesFreed += bucketMulti.free(bytesToFree - bytesFreed);
                    break block21;
                }
                PriorityQueue<BlockBucket> bucketQueue = new PriorityQueue<BlockBucket>(3);
                bucketQueue.add(bucketSingle);
                bucketQueue.add(bucketMulti);
                bucketQueue.add(bucketMemory);
                int remainingBuckets = 3;
                while ((bucket = (BlockBucket)bucketQueue.poll()) != null) {
                    long overflow = bucket.overflow();
                    if (overflow > 0L) {
                        long bucketBytesToFree = Math.min(overflow, (bytesToFree - bytesFreed) / (long)remainingBuckets);
                        bytesFreed += bucket.free(bucketBytesToFree);
                    }
                    --remainingBuckets;
                }
            }
            if (LOG.isTraceEnabled()) {
                long single = bucketSingle.totalSize();
                long multi = bucketMulti.totalSize();
                long memory = bucketMemory.totalSize();
                LOG.trace((Object)("Block cache LRU eviction completed; freed=" + StringUtils.byteDesc((long)bytesFreed) + ", " + "total=" + StringUtils.byteDesc((long)this.size.get()) + ", " + "single=" + StringUtils.byteDesc((long)single) + ", " + "multi=" + StringUtils.byteDesc((long)multi) + ", " + "memory=" + StringUtils.byteDesc((long)memory)));
            }
        }
        finally {
            this.stats.evict();
            this.evictionInProgress = false;
            this.evictionLock.unlock();
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("blockCount", this.getBlockCount()).add("currentSize", this.getCurrentSize()).add("freeSize", this.getFreeSize()).add("maxSize", this.getMaxSize()).add("heapSize", this.heapSize()).add("minSize", this.minSize()).add("minFactor", this.minFactor).add("multiSize", this.multiSize()).add("multiFactor", this.multiFactor).add("singleSize", this.singleSize()).add("singleFactor", this.singleFactor).toString();
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    @Override
    public long getCurrentSize() {
        return this.size.get();
    }

    @Override
    public long getFreeSize() {
        return this.getMaxSize() - this.getCurrentSize();
    }

    @Override
    public long size() {
        return this.getMaxSize();
    }

    @Override
    public long getBlockCount() {
        return this.elements.get();
    }

    EvictionThread getEvictionThread() {
        return this.evictionThread;
    }

    public void logStats() {
        long totalSize = this.heapSize();
        long freeSize = this.maxSize - totalSize;
        LOG.info((Object)("totalSize=" + StringUtils.byteDesc((long)totalSize) + ", " + "freeSize=" + StringUtils.byteDesc((long)freeSize) + ", " + "max=" + StringUtils.byteDesc((long)this.maxSize) + ", " + "blockCount=" + this.getBlockCount() + ", " + "accesses=" + this.stats.getRequestCount() + ", " + "hits=" + this.stats.getHitCount() + ", " + "hitRatio=" + (this.stats.getHitCount() == 0L ? "0" : StringUtils.formatPercent((double)this.stats.getHitRatio(), (int)2) + ", ") + ", " + "cachingAccesses=" + this.stats.getRequestCachingCount() + ", " + "cachingHits=" + this.stats.getHitCachingCount() + ", " + "cachingHitsRatio=" + (this.stats.getHitCachingCount() == 0L ? "0," : StringUtils.formatPercent((double)this.stats.getHitCachingRatio(), (int)2) + ", ") + "evictions=" + this.stats.getEvictionCount() + ", " + "evicted=" + this.stats.getEvictedCount() + ", " + "evictedPerRun=" + this.stats.evictedPerEviction()));
    }

    @Override
    public CacheStats getStats() {
        return this.stats;
    }

    @Override
    public long heapSize() {
        return this.getCurrentSize();
    }

    public static long calculateOverhead(long maxSize, long blockSize, int concurrency) {
        return CACHE_FIXED_OVERHEAD + (long)ClassSize.CONCURRENT_HASHMAP + (long)Math.ceil((double)maxSize * 1.2 / (double)blockSize) * (long)ClassSize.CONCURRENT_HASHMAP_ENTRY + (long)concurrency * (long)ClassSize.CONCURRENT_HASHMAP_SEGMENT;
    }

    @Override
    public Iterator<CachedBlock> iterator() {
        final Iterator<LruCachedBlock> iterator = this.map.values().iterator();
        return new Iterator<CachedBlock>(){
            private final long now = System.nanoTime();

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public CachedBlock next() {
                final LruCachedBlock b = (LruCachedBlock)iterator.next();
                return new CachedBlock(){

                    public String toString() {
                        return BlockCacheUtil.toString(this, now);
                    }

                    @Override
                    public BlockPriority getBlockPriority() {
                        return b.getPriority();
                    }

                    @Override
                    public BlockType getBlockType() {
                        return b.getBuffer().getBlockType();
                    }

                    @Override
                    public long getOffset() {
                        return b.getCacheKey().getOffset();
                    }

                    @Override
                    public long getSize() {
                        return b.getBuffer().heapSize();
                    }

                    @Override
                    public long getCachedTime() {
                        return b.getCachedTime();
                    }

                    @Override
                    public String getFilename() {
                        return b.getCacheKey().getHfileName();
                    }

                    @Override
                    public int compareTo(CachedBlock other) {
                        int diff = this.getFilename().compareTo(other.getFilename());
                        if (diff != 0) {
                            return diff;
                        }
                        diff = Long.compare(this.getOffset(), other.getOffset());
                        if (diff != 0) {
                            return diff;
                        }
                        if (other.getCachedTime() < 0L || this.getCachedTime() < 0L) {
                            throw new IllegalStateException("" + this.getCachedTime() + ", " + other.getCachedTime());
                        }
                        return Long.compare(other.getCachedTime(), this.getCachedTime());
                    }

                    public int hashCode() {
                        return b.hashCode();
                    }

                    public boolean equals(Object obj) {
                        if (obj instanceof CachedBlock) {
                            CachedBlock cb = (CachedBlock)obj;
                            return this.compareTo(cb) == 0;
                        }
                        return false;
                    }
                };
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    long acceptableSize() {
        return (long)Math.floor((float)this.maxSize * this.acceptableFactor);
    }

    private long minSize() {
        return (long)Math.floor((float)this.maxSize * this.minFactor);
    }

    private long singleSize() {
        return (long)Math.floor((float)this.maxSize * this.singleFactor * this.minFactor);
    }

    private long multiSize() {
        return (long)Math.floor((float)this.maxSize * this.multiFactor * this.minFactor);
    }

    private long memorySize() {
        return (long)Math.floor((float)this.maxSize * this.memoryFactor * this.minFactor);
    }

    @Override
    public void shutdown() {
        if (this.victimHandler != null) {
            this.victimHandler.shutdown();
        }
        this.scheduleThreadPool.shutdown();
        for (int i = 0; i < 10; ++i) {
            if (this.scheduleThreadPool.isShutdown()) continue;
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"Interrupted while sleeping");
                Thread.currentThread().interrupt();
                break;
            }
        }
        if (!this.scheduleThreadPool.isShutdown()) {
            List<Runnable> runnables = this.scheduleThreadPool.shutdownNow();
            LOG.debug((Object)("Still running " + runnables));
        }
        this.evictionThread.shutdown();
    }

    @VisibleForTesting
    public void clearCache() {
        this.map.clear();
        this.elements.set(0L);
    }

    @VisibleForTesting
    SortedSet<String> getCachedFileNamesForTest() {
        TreeSet<String> fileNames = new TreeSet<String>();
        for (BlockCacheKey cacheKey : this.map.keySet()) {
            fileNames.add(cacheKey.getHfileName());
        }
        return fileNames;
    }

    @VisibleForTesting
    Map<BlockType, Integer> getBlockTypeCountsForTest() {
        EnumMap<BlockType, Integer> counts = new EnumMap<BlockType, Integer>(BlockType.class);
        for (LruCachedBlock cb : this.map.values()) {
            BlockType blockType;
            Integer count = (Integer)counts.get((Object)(blockType = cb.getBuffer().getBlockType()));
            counts.put(blockType, (count == null ? 0 : count) + 1);
        }
        return counts;
    }

    @VisibleForTesting
    public Map<DataBlockEncoding, Integer> getEncodingCountsForTest() {
        EnumMap<DataBlockEncoding, Integer> counts = new EnumMap<DataBlockEncoding, Integer>(DataBlockEncoding.class);
        for (LruCachedBlock block : this.map.values()) {
            DataBlockEncoding encoding;
            Integer count = (Integer)counts.get((Object)(encoding = ((HFileBlock)block.getBuffer()).getDataBlockEncoding()));
            counts.put(encoding, (count == null ? 0 : count) + 1);
        }
        return counts;
    }

    public void setVictimCache(BlockCache handler) {
        assert (this.victimHandler == null);
        this.victimHandler = handler;
    }

    @VisibleForTesting
    Map<BlockCacheKey, LruCachedBlock> getMapForTests() {
        return this.map;
    }

    BlockCache getVictimHandler() {
        return this.victimHandler;
    }

    @Override
    public BlockCache[] getBlockCaches() {
        return null;
    }

    static class StatisticsThread
    extends Thread {
        private final LruBlockCache lru;

        public StatisticsThread(LruBlockCache lru) {
            super("LruBlockCacheStats");
            this.setDaemon(true);
            this.lru = lru;
        }

        @Override
        public void run() {
            this.lru.logStats();
        }
    }

    static class EvictionThread
    extends HasThread {
        private WeakReference<LruBlockCache> cache;
        private volatile boolean go = true;
        private boolean enteringRun = false;

        public EvictionThread(LruBlockCache cache) {
            super(Thread.currentThread().getName() + ".LruBlockCache.EvictionThread");
            this.setDaemon(true);
            this.cache = new WeakReference<LruBlockCache>(cache);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.enteringRun = true;
            while (this.go) {
                EvictionThread evictionThread = this;
                synchronized (evictionThread) {
                    try {
                        this.wait(10000L);
                    }
                    catch (InterruptedException e) {
                        LOG.warn((Object)"Interrupted eviction thread ", (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                }
                LruBlockCache cache = (LruBlockCache)this.cache.get();
                if (cache == null) break;
                cache.evict();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressWarnings(value={"NN_NAKED_NOTIFY"}, justification="This is what we want")
        public void evict() {
            EvictionThread evictionThread = this;
            synchronized (evictionThread) {
                this.notifyAll();
            }
        }

        synchronized void shutdown() {
            this.go = false;
            this.notifyAll();
        }

        boolean isEnteringRun() {
            return this.enteringRun;
        }
    }

    private class BlockBucket
    implements Comparable<BlockBucket> {
        private final String name;
        private LruCachedBlockQueue queue;
        private long totalSize = 0L;
        private long bucketSize;

        public BlockBucket(String name, long bytesToFree, long blockSize, long bucketSize) {
            this.name = name;
            this.bucketSize = bucketSize;
            this.queue = new LruCachedBlockQueue(bytesToFree, blockSize);
            this.totalSize = 0L;
        }

        public void add(LruCachedBlock block) {
            this.totalSize += block.heapSize();
            this.queue.add(block);
        }

        public long free(long toFree) {
            LruCachedBlock cb;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("freeing " + StringUtils.byteDesc((long)toFree) + " from " + this));
            }
            long freedBytes = 0L;
            while ((cb = this.queue.pollLast()) != null) {
                if ((freedBytes += LruBlockCache.this.evictBlock(cb, true)) < toFree) continue;
                return freedBytes;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("freed " + StringUtils.byteDesc((long)freedBytes) + " from " + this));
            }
            return freedBytes;
        }

        public long overflow() {
            return this.totalSize - this.bucketSize;
        }

        public long totalSize() {
            return this.totalSize;
        }

        @Override
        public int compareTo(BlockBucket that) {
            return Long.compare(this.overflow(), that.overflow());
        }

        public boolean equals(Object that) {
            if (that == null || !(that instanceof BlockBucket)) {
                return false;
            }
            return this.compareTo((BlockBucket)that) == 0;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.bucketSize, this.queue, this.totalSize});
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("totalSize", (Object)StringUtils.byteDesc((long)this.totalSize)).add("bucketSize", (Object)StringUtils.byteDesc((long)this.bucketSize)).toString();
        }
    }
}

