/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.ipc;

import com.google.common.annotations.VisibleForTesting;
import java.net.SocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.RpcClientImpl;
import org.apache.hudi.org.apache.hadoop.hbase.util.ReflectionUtils;

@InterfaceAudience.Private
public final class RpcClientFactory {
    public static final String CUSTOM_RPC_CLIENT_IMPL_CONF_KEY = "hbase.rpc.client.impl";

    private RpcClientFactory() {
    }

    @VisibleForTesting
    public static RpcClient createClient(Configuration conf, String clusterId) {
        return RpcClientFactory.createClient(conf, clusterId, null);
    }

    public static RpcClient createClient(Configuration conf, String clusterId, MetricsConnection metrics) {
        return RpcClientFactory.createClient(conf, clusterId, null, metrics);
    }

    public static RpcClient createClient(Configuration conf, String clusterId, SocketAddress localAddr, MetricsConnection metrics) {
        String rpcClientClass = conf.get(CUSTOM_RPC_CLIENT_IMPL_CONF_KEY, RpcClientImpl.class.getName());
        return (RpcClient)ReflectionUtils.instantiateWithCustomCtor(rpcClientClass, new Class[]{Configuration.class, String.class, SocketAddress.class, MetricsConnection.class}, new Object[]{conf, clusterId, localAddr, metrics});
    }
}

