/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.Comparator;
import java.util.TreeSet;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hudi.org.apache.hadoop.hbase.KeyValue;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hudi.org.apache.hadoop.hbase.io.ImmutableBytesWritable;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class KeyValueSortReducer
extends Reducer<ImmutableBytesWritable, KeyValue, ImmutableBytesWritable, KeyValue> {
    protected void reduce(ImmutableBytesWritable row, Iterable<KeyValue> kvs, Reducer.Context context) throws IOException, InterruptedException {
        TreeSet<KeyValue> map = new TreeSet<KeyValue>((Comparator<KeyValue>)((Object)KeyValue.COMPARATOR));
        for (KeyValue kv : kvs) {
            try {
                map.add(kv.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new IOException(e);
            }
        }
        context.setStatus("Read " + map.getClass());
        int index = 0;
        for (KeyValue kv : map) {
            context.write((Object)row, (Object)kv);
            if (++index % 100 != 0) continue;
            context.setStatus("Wrote " + index);
        }
    }
}

