/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master;

import org.apache.commons.lang.StringUtils;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.master.HMaster;
import org.apache.hudi.org.apache.hadoop.hbase.master.MetricsMasterWrapper;
import org.apache.hudi.org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

@InterfaceAudience.Private
public class MetricsMasterWrapperImpl
implements MetricsMasterWrapper {
    private final HMaster master;

    public MetricsMasterWrapperImpl(HMaster master) {
        this.master = master;
    }

    public double getAverageLoad() {
        return this.master.getAverageLoad();
    }

    public String getClusterId() {
        return this.master.getClusterId();
    }

    public String getZookeeperQuorum() {
        ZooKeeperWatcher zk = this.master.getZooKeeper();
        if (zk == null) {
            return "";
        }
        return zk.getQuorum();
    }

    public String[] getCoprocessors() {
        return this.master.getMasterCoprocessors();
    }

    public long getStartTime() {
        return this.master.getMasterStartTime();
    }

    public long getActiveTime() {
        return this.master.getMasterActiveTime();
    }

    public String getRegionServers() {
        ServerManager serverManager = this.master.getServerManager();
        if (serverManager == null) {
            return "";
        }
        return StringUtils.join(serverManager.getOnlineServers().keySet(), (String)";");
    }

    public int getNumRegionServers() {
        ServerManager serverManager = this.master.getServerManager();
        if (serverManager == null) {
            return 0;
        }
        return serverManager.getOnlineServers().size();
    }

    public String getDeadRegionServers() {
        ServerManager serverManager = this.master.getServerManager();
        if (serverManager == null) {
            return "";
        }
        return StringUtils.join(serverManager.getDeadServers().copyServerNames(), (String)";");
    }

    public int getNumDeadRegionServers() {
        ServerManager serverManager = this.master.getServerManager();
        if (serverManager == null) {
            return 0;
        }
        return serverManager.getDeadServers().size();
    }

    public String getServerName() {
        ServerName serverName = this.master.getServerName();
        if (serverName == null) {
            return "";
        }
        return serverName.getServerName();
    }

    public boolean getIsActiveMaster() {
        return this.master.isActiveMaster();
    }
}

