/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.client.Admin;
import org.apache.hudi.org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hudi.org.apache.hadoop.hbase.client.Connection;
import org.apache.hudi.org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hudi.org.apache.hadoop.hbase.master.AssignmentVerificationReport;
import org.apache.hudi.org.apache.hadoop.hbase.master.RackManager;
import org.apache.hudi.org.apache.hadoop.hbase.master.SnapshotOfRegionAssignmentFromMeta;
import org.apache.hudi.org.apache.hadoop.hbase.master.balancer.FavoredNodeAssignmentHelper;
import org.apache.hudi.org.apache.hadoop.hbase.master.balancer.FavoredNodesPlan;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hudi.org.apache.hadoop.hbase.util.MunkresAssignment;
import org.apache.hudi.org.apache.hadoop.hbase.util.Pair;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

@InterfaceAudience.Private
public class RegionPlacementMaintainer {
    private static final Log LOG = LogFactory.getLog((String)RegionPlacementMaintainer.class.getName());
    private static final float MAX_COST = Float.POSITIVE_INFINITY;
    private static final float AVOID_COST = 100000.0f;
    private static final float LAST_SLOT_COST_PENALTY = 0.5f;
    private static final float NOT_CURRENT_HOST_PENALTY = 0.1f;
    private static boolean USE_MUNKRES_FOR_PLACING_SECONDARY_AND_TERTIARY = false;
    private Configuration conf;
    private final boolean enforceLocality;
    private final boolean enforceMinAssignmentMove;
    private RackManager rackManager;
    private Set<TableName> targetTableSet;
    private final Connection connection;

    public RegionPlacementMaintainer(Configuration conf) {
        this(conf, true, true);
    }

    public RegionPlacementMaintainer(Configuration conf, boolean enforceLocality, boolean enforceMinAssignmentMove) {
        this.conf = conf;
        this.enforceLocality = enforceLocality;
        this.enforceMinAssignmentMove = enforceMinAssignmentMove;
        this.targetTableSet = new HashSet<TableName>();
        this.rackManager = new RackManager(conf);
        try {
            this.connection = ConnectionFactory.createConnection(this.conf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void printHelp(Options opt) {
        new HelpFormatter().printHelp("RegionPlacement < -w | -u | -n | -v | -t | -h | -overwrite -r regionName -f favoredNodes -diff> [-l false] [-m false] [-d] [-tables t1,t2,...tn] [-zk zk1,zk2,zk3] [-fs hdfs://a.b.c.d:9000] [-hbase_root /HBASE]", opt);
    }

    public void setTargetTableName(String[] tableNames) {
        if (tableNames != null) {
            for (String table : tableNames) {
                this.targetTableSet.add(TableName.valueOf(table));
            }
        }
    }

    public SnapshotOfRegionAssignmentFromMeta getRegionAssignmentSnapshot() throws IOException {
        SnapshotOfRegionAssignmentFromMeta currentAssignmentShapshot = new SnapshotOfRegionAssignmentFromMeta(ConnectionFactory.createConnection(this.conf));
        currentAssignmentShapshot.initialize();
        return currentAssignmentShapshot;
    }

    public List<AssignmentVerificationReport> verifyRegionPlacement(boolean isDetailMode) throws IOException {
        System.out.println("Start to verify the region assignment and generate the verification report");
        SnapshotOfRegionAssignmentFromMeta snapshot = this.getRegionAssignmentSnapshot();
        Set<TableName> tables = snapshot.getTableSet();
        Map<String, Map<String, Float>> regionLocalityMap = null;
        if (this.enforceLocality) {
            regionLocalityMap = FSUtils.getRegionDegreeLocalityMappingFromFS(this.conf);
        }
        ArrayList<AssignmentVerificationReport> reports = new ArrayList<AssignmentVerificationReport>();
        for (TableName table : tables) {
            if (!this.targetTableSet.isEmpty() && !this.targetTableSet.contains(table)) continue;
            AssignmentVerificationReport report = new AssignmentVerificationReport();
            report.fillUp(table, snapshot, regionLocalityMap);
            report.print(isDetailMode);
            reports.add(report);
        }
        return reports;
    }

    private void genAssignmentPlan(TableName tableName, SnapshotOfRegionAssignmentFromMeta assignmentSnapshot, Map<String, Map<String, Float>> regionLocalityMap, FavoredNodesPlan plan, boolean munkresForSecondaryAndTertiary) throws IOException {
        List<HRegionInfo> regions = assignmentSnapshot.getTableToRegionMap().get(tableName);
        int numRegions = regions.size();
        Map<HRegionInfo, ServerName> currentAssignmentMap = assignmentSnapshot.getRegionToRegionServerMap();
        ArrayList<ServerName> servers = new ArrayList<ServerName>();
        try (Admin admin = this.connection.getAdmin();){
            servers.addAll(admin.getClusterStatus().getServers());
        }
        LOG.info((Object)("Start to generate assignment plan for " + numRegions + " regions from table " + tableName + " with " + servers.size() + " region servers"));
        int slotsPerServer = (int)Math.ceil((float)numRegions / (float)servers.size());
        int regionSlots = slotsPerServer * servers.size();
        float[][] primaryCost = new float[numRegions][regionSlots];
        float[][] secondaryCost = new float[numRegions][regionSlots];
        float[][] tertiaryCost = new float[numRegions][regionSlots];
        if (this.enforceLocality && regionLocalityMap != null) {
            int i;
            float[][] localityPerServer = new float[numRegions][regionSlots];
            for (int i2 = 0; i2 < numRegions; ++i2) {
                Map<String, Float> serverLocalityMap = regionLocalityMap.get(regions.get(i2).getEncodedName());
                if (serverLocalityMap == null) continue;
                for (int j = 0; j < servers.size(); ++j) {
                    Float locality;
                    String serverName = ((ServerName)servers.get(j)).getHostname();
                    if (serverName == null || (locality = serverLocalityMap.get(serverName)) == null) continue;
                    for (int k = 0; k < slotsPerServer; ++k) {
                        localityPerServer[i2][j * slotsPerServer + k] = locality.floatValue();
                    }
                }
            }
            HashMap rackRegionLocality = new HashMap();
            for (i = 0; i < numRegions; ++i) {
                HRegionInfo region = regions.get(i);
                for (int j = 0; j < regionSlots; j += slotsPerServer) {
                    Float localityObj;
                    String rack = this.rackManager.getRack((ServerName)servers.get(j / slotsPerServer));
                    HashMap<HRegionInfo, Float> rackLocality = (HashMap<HRegionInfo, Float>)rackRegionLocality.get(rack);
                    if (rackLocality == null) {
                        rackLocality = new HashMap<HRegionInfo, Float>();
                        rackRegionLocality.put(rack, rackLocality);
                    }
                    float locality = (localityObj = (Float)rackLocality.get(region)) == null ? 0.0f : localityObj.floatValue();
                    rackLocality.put(region, Float.valueOf(locality += localityPerServer[i][j]));
                }
            }
            for (i = 0; i < numRegions; ++i) {
                for (int j = 0; j < regionSlots; ++j) {
                    String rack = this.rackManager.getRack((ServerName)servers.get(j / slotsPerServer));
                    Float totalRackLocalityObj = (Float)((Map)rackRegionLocality.get(rack)).get(regions.get(i));
                    float totalRackLocality = totalRackLocalityObj == null ? 0.0f : totalRackLocalityObj.floatValue();
                    primaryCost[i][j] = 1.0f - (2.0f * localityPerServer[i][j] - totalRackLocality);
                    secondaryCost[i][j] = 2.0f - (localityPerServer[i][j] + totalRackLocality);
                    tertiaryCost[i][j] = 1.0f - localityPerServer[i][j];
                }
            }
        }
        if (this.enforceMinAssignmentMove && currentAssignmentMap != null) {
            for (int i = 0; i < numRegions; ++i) {
                for (int j = 0; j < servers.size(); ++j) {
                    ServerName currentAddress = currentAssignmentMap.get(regions.get(i));
                    if (currentAddress == null || currentAddress.equals(servers.get(j))) continue;
                    for (int k = 0; k < slotsPerServer; ++k) {
                        float[] fArray = primaryCost[i];
                        int n = j * slotsPerServer + k;
                        fArray[n] = fArray[n] + 0.1f;
                    }
                }
            }
        }
        for (int i = 0; i < numRegions; ++i) {
            for (int j = 0; j < regionSlots; j += slotsPerServer) {
                float[] fArray = primaryCost[i];
                int n = j;
                fArray[n] = fArray[n] + 0.5f;
                float[] fArray2 = secondaryCost[i];
                int n2 = j;
                fArray2[n2] = fArray2[n2] + 0.5f;
                float[] fArray3 = tertiaryCost[i];
                int n3 = j;
                fArray3[n3] = fArray3[n3] + 0.5f;
            }
        }
        RandomizedMatrix randomizedMatrix = new RandomizedMatrix(numRegions, regionSlots);
        primaryCost = randomizedMatrix.transform(primaryCost);
        int[] primaryAssignment = new MunkresAssignment(primaryCost).solve();
        primaryAssignment = randomizedMatrix.invertIndices(primaryAssignment);
        for (int i = 0; i < numRegions; ++i) {
            int slot = primaryAssignment[i];
            String rack = this.rackManager.getRack((ServerName)servers.get(slot / slotsPerServer));
            for (int k = 0; k < servers.size(); ++k) {
                int m;
                if (!this.rackManager.getRack((ServerName)servers.get(k)).equals(rack)) continue;
                if (k == slot / slotsPerServer) {
                    for (m = 0; m < slotsPerServer; ++m) {
                        secondaryCost[i][k * slotsPerServer + m] = Float.POSITIVE_INFINITY;
                        tertiaryCost[i][k * slotsPerServer + m] = Float.POSITIVE_INFINITY;
                    }
                    continue;
                }
                for (m = 0; m < slotsPerServer; ++m) {
                    secondaryCost[i][k * slotsPerServer + m] = 100000.0f;
                    tertiaryCost[i][k * slotsPerServer + m] = 100000.0f;
                }
            }
        }
        if (munkresForSecondaryAndTertiary) {
            randomizedMatrix = new RandomizedMatrix(numRegions, regionSlots);
            secondaryCost = randomizedMatrix.transform(secondaryCost);
            int[] secondaryAssignment = new MunkresAssignment(secondaryCost).solve();
            secondaryAssignment = randomizedMatrix.invertIndices(secondaryAssignment);
            for (int i = 0; i < numRegions; ++i) {
                int slot = secondaryAssignment[i];
                String rack = this.rackManager.getRack((ServerName)servers.get(slot / slotsPerServer));
                for (int k = 0; k < servers.size(); ++k) {
                    int m;
                    if (k == slot / slotsPerServer) {
                        for (m = 0; m < slotsPerServer; ++m) {
                            tertiaryCost[i][k * slotsPerServer + m] = Float.POSITIVE_INFINITY;
                        }
                        continue;
                    }
                    if (this.rackManager.getRack((ServerName)servers.get(k)).equals(rack)) continue;
                    for (m = 0; m < slotsPerServer; ++m) {
                        tertiaryCost[i][k * slotsPerServer + m] = 100000.0f;
                    }
                }
            }
            randomizedMatrix = new RandomizedMatrix(numRegions, regionSlots);
            tertiaryCost = randomizedMatrix.transform(tertiaryCost);
            int[] tertiaryAssignment = new MunkresAssignment(tertiaryCost).solve();
            tertiaryAssignment = randomizedMatrix.invertIndices(tertiaryAssignment);
            for (int i = 0; i < numRegions; ++i) {
                ArrayList<ServerName> favoredServers = new ArrayList<ServerName>(3);
                ServerName s = (ServerName)servers.get(primaryAssignment[i] / slotsPerServer);
                favoredServers.add(ServerName.valueOf(s.getHostname(), s.getPort(), -1L));
                s = (ServerName)servers.get(secondaryAssignment[i] / slotsPerServer);
                favoredServers.add(ServerName.valueOf(s.getHostname(), s.getPort(), -1L));
                s = (ServerName)servers.get(tertiaryAssignment[i] / slotsPerServer);
                favoredServers.add(ServerName.valueOf(s.getHostname(), s.getPort(), -1L));
                plan.updateAssignmentPlan(regions.get(i), favoredServers);
            }
            LOG.info((Object)("Generated the assignment plan for " + numRegions + " regions from table " + tableName + " with " + servers.size() + " region servers"));
            LOG.info((Object)"Assignment plan for secondary and tertiary generated using MunkresAssignment");
        } else {
            HashMap<HRegionInfo, ServerName> primaryRSMap = new HashMap<HRegionInfo, ServerName>();
            for (int i = 0; i < numRegions; ++i) {
                primaryRSMap.put(regions.get(i), (ServerName)servers.get(primaryAssignment[i] / slotsPerServer));
            }
            FavoredNodeAssignmentHelper favoredNodeHelper = new FavoredNodeAssignmentHelper(servers, this.conf);
            favoredNodeHelper.initialize();
            Map<HRegionInfo, ServerName[]> secondaryAndTertiaryMap = favoredNodeHelper.placeSecondaryAndTertiaryWithRestrictions(primaryRSMap);
            for (int i = 0; i < numRegions; ++i) {
                ArrayList<ServerName> favoredServers = new ArrayList<ServerName>(3);
                HRegionInfo currentRegion = regions.get(i);
                ServerName s = (ServerName)primaryRSMap.get(currentRegion);
                favoredServers.add(ServerName.valueOf(s.getHostname(), s.getPort(), -1L));
                ServerName[] secondaryAndTertiary = secondaryAndTertiaryMap.get(currentRegion);
                s = secondaryAndTertiary[0];
                favoredServers.add(ServerName.valueOf(s.getHostname(), s.getPort(), -1L));
                s = secondaryAndTertiary[1];
                favoredServers.add(ServerName.valueOf(s.getHostname(), s.getPort(), -1L));
                plan.updateAssignmentPlan(regions.get(i), favoredServers);
            }
            LOG.info((Object)("Generated the assignment plan for " + numRegions + " regions from table " + tableName + " with " + servers.size() + " region servers"));
            LOG.info((Object)"Assignment plan for secondary and tertiary generated using placeSecondaryAndTertiaryWithRestrictions method");
        }
    }

    public FavoredNodesPlan getNewAssignmentPlan() throws IOException {
        SnapshotOfRegionAssignmentFromMeta assignmentSnapshot = this.getRegionAssignmentSnapshot();
        Map<String, Map<String, Float>> regionLocalityMap = null;
        if (this.enforceLocality) {
            regionLocalityMap = FSUtils.getRegionDegreeLocalityMappingFromFS(this.conf);
        }
        FavoredNodesPlan plan = new FavoredNodesPlan();
        Map<TableName, List<HRegionInfo>> tableToRegionMap = assignmentSnapshot.getTableToRegionMap();
        LOG.info((Object)("Start to generate the new assignment plan for the " + tableToRegionMap.keySet().size() + " tables"));
        for (TableName table : tableToRegionMap.keySet()) {
            try {
                if (!this.targetTableSet.isEmpty() && !this.targetTableSet.contains(table)) continue;
                this.genAssignmentPlan(table, assignmentSnapshot, regionLocalityMap, plan, USE_MUNKRES_FOR_PLACING_SECONDARY_AND_TERTIARY);
            }
            catch (Exception e) {
                LOG.error((Object)("Get some exceptions for placing primary region serverfor table " + table + " because " + e));
            }
        }
        LOG.info((Object)("Finish to generate the new assignment plan for the " + tableToRegionMap.keySet().size() + " tables"));
        return plan;
    }

    public static void printAssignmentPlan(FavoredNodesPlan plan) {
        if (plan == null) {
            return;
        }
        LOG.info((Object)"========== Start to print the assignment plan ================");
        TreeMap<HRegionInfo, List<ServerName>> assignmentMap = new TreeMap<HRegionInfo, List<ServerName>>(plan.getAssignmentMap());
        for (Map.Entry entry : assignmentMap.entrySet()) {
            String serverList = FavoredNodeAssignmentHelper.getFavoredNodesAsString((List)entry.getValue());
            String regionName = ((HRegionInfo)entry.getKey()).getRegionNameAsString();
            LOG.info((Object)("Region: " + regionName));
            LOG.info((Object)("Its favored nodes: " + serverList));
        }
        LOG.info((Object)"========== Finish to print the assignment plan ================");
    }

    public void updateAssignmentPlanToMeta(FavoredNodesPlan plan) throws IOException {
        try {
            LOG.info((Object)"Start to update the hbase:meta with the new assignment plan");
            Map<HRegionInfo, List<ServerName>> assignmentMap = plan.getAssignmentMap();
            FavoredNodeAssignmentHelper.updateMetaWithFavoredNodesInfo(assignmentMap, this.conf);
            LOG.info((Object)"Updated the hbase:meta with the new assignment plan");
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to update hbase:meta with the new assignmentplan because " + e.getMessage()));
        }
    }

    private void updateAssignmentPlanToRegionServers(FavoredNodesPlan plan) throws IOException {
        LOG.info((Object)"Start to update the region servers with the new assignment plan");
        Map<ServerName, List<HRegionInfo>> currentAssignment = this.getRegionAssignmentSnapshot().getRegionServerToRegionMap();
        int succeededNum = 0;
        HashMap<ServerName, Exception> failedUpdateMap = new HashMap<ServerName, Exception>();
        for (Map.Entry<ServerName, List<HRegionInfo>> entry : currentAssignment.entrySet()) {
            ArrayList<Pair<HRegionInfo, List<ServerName>>> regionUpdateInfos = new ArrayList<Pair<HRegionInfo, List<ServerName>>>();
            try {
                FavoredNodesPlan singleServerPlan = null;
                for (HRegionInfo region : entry.getValue()) {
                    List<ServerName> favoredServerList = plan.getFavoredNodes(region);
                    if (favoredServerList == null || favoredServerList.size() != 3) continue;
                    if (singleServerPlan == null) {
                        singleServerPlan = new FavoredNodesPlan();
                    }
                    singleServerPlan.updateAssignmentPlan(region, favoredServerList);
                    regionUpdateInfos.add(new Pair<HRegionInfo, List<ServerName>>(region, favoredServerList));
                }
                if (singleServerPlan == null) continue;
                AdminProtos.AdminService.BlockingInterface currentRegionServer = ((ClusterConnection)this.connection).getAdmin(entry.getKey());
                AdminProtos.UpdateFavoredNodesRequest request = RequestConverter.buildUpdateFavoredNodesRequest(regionUpdateInfos);
                AdminProtos.UpdateFavoredNodesResponse updateFavoredNodesResponse = currentRegionServer.updateFavoredNodes(null, request);
                LOG.info((Object)("Region server " + ProtobufUtil.getServerInfo(null, currentRegionServer).getServerName() + " has updated " + updateFavoredNodesResponse.getResponse() + " / " + singleServerPlan.getAssignmentMap().size() + " regions with the assignment plan"));
                ++succeededNum;
            }
            catch (Exception e) {
                failedUpdateMap.put(entry.getKey(), e);
            }
        }
        LOG.info((Object)("Updated " + succeededNum + " region servers with " + "the new assignment plan"));
        int failedNum = failedUpdateMap.size();
        if (failedNum != 0) {
            LOG.error((Object)("Failed to update the following + " + failedNum + " region servers with its corresponding favored nodes"));
            for (Map.Entry entry : failedUpdateMap.entrySet()) {
                LOG.error((Object)("Failed to update " + ((ServerName)entry.getKey()).getHostAndPort() + " because of " + ((Exception)entry.getValue()).getMessage()));
            }
        }
    }

    public void updateAssignmentPlan(FavoredNodesPlan plan) throws IOException {
        LOG.info((Object)"Start to update the new assignment plan for the hbase:meta table and the region servers");
        this.updateAssignmentPlanToMeta(plan);
        this.updateAssignmentPlanToRegionServers(plan);
        LOG.info((Object)"Finish to update the new assignment plan for the hbase:meta table and the region servers");
    }

    public Map<TableName, Integer> getRegionsMovement(FavoredNodesPlan newPlan) throws IOException {
        HashMap<TableName, Integer> movesPerTable = new HashMap<TableName, Integer>();
        SnapshotOfRegionAssignmentFromMeta snapshot = this.getRegionAssignmentSnapshot();
        Map<TableName, List<HRegionInfo>> tableToRegions = snapshot.getTableToRegionMap();
        FavoredNodesPlan oldPlan = snapshot.getExistingAssignmentPlan();
        Set<TableName> tables = snapshot.getTableSet();
        for (TableName table : tables) {
            int movedPrimaries = 0;
            if (!this.targetTableSet.isEmpty() && !this.targetTableSet.contains(table)) continue;
            List<HRegionInfo> regions = tableToRegions.get(table);
            for (HRegionInfo region : regions) {
                ServerName newPrimary;
                ServerName oldPrimary;
                List<ServerName> oldServers = oldPlan.getFavoredNodes(region);
                List<ServerName> newServers = newPlan.getFavoredNodes(region);
                if (oldServers == null || newServers == null || (oldPrimary = oldServers.get(0)).compareTo(newPrimary = newServers.get(0)) == 0) continue;
                ++movedPrimaries;
            }
            movesPerTable.put(table, movedPrimaries);
        }
        return movesPerTable;
    }

    public void checkDifferencesWithOldPlan(Map<TableName, Integer> movesPerTable, Map<String, Map<String, Float>> regionLocalityMap, FavoredNodesPlan newPlan) throws IOException {
        SnapshotOfRegionAssignmentFromMeta snapshot = this.getRegionAssignmentSnapshot();
        FavoredNodesPlan oldPlan = snapshot.getExistingAssignmentPlan();
        Set<TableName> tables = snapshot.getTableSet();
        Map<TableName, List<HRegionInfo>> tableToRegionsMap = snapshot.getTableToRegionMap();
        for (TableName table : tables) {
            float[] deltaLocality = new float[3];
            float[] locality = new float[3];
            if (!this.targetTableSet.isEmpty() && !this.targetTableSet.contains(table)) continue;
            List<HRegionInfo> regions = tableToRegionsMap.get(table);
            System.out.println("==================================================");
            System.out.println("Assignment Plan Projection Report For Table: " + table);
            System.out.println("\t Total regions: " + regions.size());
            System.out.println("\t" + movesPerTable.get(table) + " primaries will move due to their primary has changed");
            for (HRegionInfo currentRegion : regions) {
                Map<String, Float> regionLocality = regionLocalityMap.get(currentRegion.getEncodedName());
                if (regionLocality == null) continue;
                List<ServerName> oldServers = oldPlan.getFavoredNodes(currentRegion);
                List<ServerName> newServers = newPlan.getFavoredNodes(currentRegion);
                if (newServers == null || oldServers == null) continue;
                int i = 0;
                for (FavoredNodesPlan.Position p : FavoredNodesPlan.Position.values()) {
                    Float newLocality;
                    ServerName newServer = newServers.get(p.ordinal());
                    ServerName oldServer = oldServers.get(p.ordinal());
                    Float oldLocality = Float.valueOf(0.0f);
                    if (oldServers != null) {
                        oldLocality = regionLocality.get(oldServer.getHostname());
                        if (oldLocality == null) {
                            oldLocality = Float.valueOf(0.0f);
                        }
                        int n = i;
                        locality[n] = locality[n] + oldLocality.floatValue();
                    }
                    if ((newLocality = regionLocality.get(newServer.getHostname())) == null) {
                        newLocality = Float.valueOf(0.0f);
                    }
                    int n = i++;
                    deltaLocality[n] = deltaLocality[n] + (newLocality.floatValue() - oldLocality.floatValue());
                }
            }
            DecimalFormat df = new DecimalFormat("#.##");
            for (int i = 0; i < deltaLocality.length; ++i) {
                System.out.print("\t\t Baseline locality for ");
                if (i == 0) {
                    System.out.print("primary ");
                } else if (i == 1) {
                    System.out.print("secondary ");
                } else if (i == 2) {
                    System.out.print("tertiary ");
                }
                System.out.println(df.format(100.0f * locality[i] / (float)regions.size()) + "%");
                System.out.print("\t\t Locality will change with the new plan: ");
                System.out.println(df.format(100.0f * deltaLocality[i] / (float)regions.size()) + "%");
            }
            System.out.println("\t Baseline dispersion");
            this.printDispersionScores(table, snapshot, regions.size(), null, true);
            System.out.println("\t Projected dispersion");
            this.printDispersionScores(table, snapshot, regions.size(), newPlan, true);
        }
    }

    public void printDispersionScores(TableName table, SnapshotOfRegionAssignmentFromMeta snapshot, int numRegions, FavoredNodesPlan newPlan, boolean simplePrint) {
        if (!this.targetTableSet.isEmpty() && !this.targetTableSet.contains(table)) {
            return;
        }
        AssignmentVerificationReport report = new AssignmentVerificationReport();
        report.fillUpDispersion(table, snapshot, newPlan);
        List<Float> dispersion = report.getDispersionInformation();
        if (simplePrint) {
            DecimalFormat df = new DecimalFormat("#.##");
            System.out.println("\tAvg dispersion score: " + df.format(dispersion.get(0)) + " hosts;\tMax dispersion score: " + df.format(dispersion.get(1)) + " hosts;\tMin dispersion score: " + df.format(dispersion.get(2)) + " hosts;");
        } else {
            LOG.info((Object)("For Table: " + table + " ; #Total Regions: " + numRegions + " ; The average dispersion score is " + dispersion.get(0)));
        }
    }

    public void printLocalityAndDispersionForCurrentPlan(Map<String, Map<String, Float>> regionLocalityMap) throws IOException {
        SnapshotOfRegionAssignmentFromMeta snapshot = this.getRegionAssignmentSnapshot();
        FavoredNodesPlan assignmentPlan = snapshot.getExistingAssignmentPlan();
        Set<TableName> tables = snapshot.getTableSet();
        Map<TableName, List<HRegionInfo>> tableToRegionsMap = snapshot.getTableToRegionMap();
        for (TableName table : tables) {
            float[] locality = new float[3];
            if (!this.targetTableSet.isEmpty() && !this.targetTableSet.contains(table)) continue;
            List<HRegionInfo> regions = tableToRegionsMap.get(table);
            for (HRegionInfo currentRegion : regions) {
                List<ServerName> servers;
                Map<String, Float> regionLocality = regionLocalityMap.get(currentRegion.getEncodedName());
                if (regionLocality == null || (servers = assignmentPlan.getFavoredNodes(currentRegion)) == null) continue;
                int i = 0;
                for (FavoredNodesPlan.Position p : FavoredNodesPlan.Position.values()) {
                    ServerName server = servers.get(p.ordinal());
                    Float currentLocality = Float.valueOf(0.0f);
                    if (servers != null) {
                        currentLocality = regionLocality.get(server.getHostname());
                        if (currentLocality == null) {
                            currentLocality = Float.valueOf(0.0f);
                        }
                        int n = i;
                        locality[n] = locality[n] + currentLocality.floatValue();
                    }
                    ++i;
                }
            }
            for (int i = 0; i < locality.length; ++i) {
                String copy = null;
                if (i == 0) {
                    copy = "primary";
                } else if (i == 1) {
                    copy = "secondary";
                } else if (i == 2) {
                    copy = "tertiary";
                }
                float avgLocality = 100.0f * locality[i] / (float)regions.size();
                LOG.info((Object)("For Table: " + table + " ; #Total Regions: " + regions.size() + " ; The average locality for " + copy + " is " + avgLocality + " %"));
            }
            this.printDispersionScores(table, snapshot, regions.size(), null, false);
        }
    }

    public static List<ServerName> getFavoredNodeList(String favoredNodesStr) {
        String[] favoredNodesArray = StringUtils.split((String)favoredNodesStr, (String)",");
        if (favoredNodesArray == null) {
            return null;
        }
        ArrayList<ServerName> serverList = new ArrayList<ServerName>();
        for (String hostNameAndPort : favoredNodesArray) {
            serverList.add(ServerName.valueOf(hostNameAndPort, -1L));
        }
        return serverList;
    }

    public static void main(String[] args) throws IOException {
        block23: {
            Options opt = new Options();
            opt.addOption("w", "write", false, "write the assignments to hbase:meta only");
            opt.addOption("u", "update", false, "update the assignments to hbase:meta and RegionServers together");
            opt.addOption("n", "dry-run", false, "do not write assignments to META");
            opt.addOption("v", "verify", false, "verify current assignments against META");
            opt.addOption("p", "print", false, "print the current assignment plan in META");
            opt.addOption("h", "help", false, "print usage");
            opt.addOption("d", "verification-details", false, "print the details of verification report");
            opt.addOption("zk", true, "to set the zookeeper quorum");
            opt.addOption("fs", true, "to set HDFS");
            opt.addOption("hbase_root", true, "to set hbase_root directory");
            opt.addOption("overwrite", false, "overwrite the favored nodes for a single region,for example: -update -r regionName -f server1:port,server2:port,server3:port");
            opt.addOption("r", true, "The region name that needs to be updated");
            opt.addOption("f", true, "The new favored nodes");
            opt.addOption("tables", true, "The list of table names splitted by ',' ;For example: -tables: t1,t2,...,tn");
            opt.addOption("l", "locality", true, "enforce the maxium locality");
            opt.addOption("m", "min-move", true, "enforce minium assignment move");
            opt.addOption("diff", false, "calculate difference between assignment plans");
            opt.addOption("munkres", false, "use munkres to place secondaries and tertiaries");
            opt.addOption("ld", "locality-dispersion", false, "print locality and dispersion information for current plan");
            try {
                FavoredNodesPlan plan;
                Logger.getLogger((String)"org.apache.zookeeper").setLevel(Level.ERROR);
                Logger.getLogger((String)"org.apache.hadoop.hbase").setLevel(Level.ERROR);
                Logger.getLogger((String)"org.apache.hudi.org.apache.hadoop.hbase.master.RegionPlacementMaintainer").setLevel(Level.INFO);
                CommandLine cmd = new GnuParser().parse(opt, args);
                Configuration conf = HBaseConfiguration.create();
                boolean enforceMinAssignmentMove = true;
                boolean enforceLocality = true;
                boolean verificationDetails = false;
                if (cmd.hasOption("l") && cmd.getOptionValue("l").equalsIgnoreCase("false") || cmd.hasOption("locality") && cmd.getOptionValue("locality").equalsIgnoreCase("false")) {
                    enforceLocality = false;
                }
                if (cmd.hasOption("m") && cmd.getOptionValue("m").equalsIgnoreCase("false") || cmd.hasOption("min-move") && cmd.getOptionValue("min-move").equalsIgnoreCase("false")) {
                    enforceMinAssignmentMove = false;
                }
                if (cmd.hasOption("zk")) {
                    conf.set("hbase.zookeeper.quorum", cmd.getOptionValue("zk"));
                    LOG.info((Object)("Setting the zk quorum: " + conf.get("hbase.zookeeper.quorum")));
                }
                if (cmd.hasOption("fs")) {
                    conf.set("fs.defaultFS", cmd.getOptionValue("fs"));
                    LOG.info((Object)("Setting the HDFS: " + conf.get("fs.defaultFS")));
                }
                if (cmd.hasOption("hbase_root")) {
                    conf.set("hbase.rootdir", cmd.getOptionValue("hbase_root"));
                    LOG.info((Object)("Setting the hbase root directory: " + conf.get("hbase.rootdir")));
                }
                RegionPlacementMaintainer rp = new RegionPlacementMaintainer(conf, enforceLocality, enforceMinAssignmentMove);
                if (cmd.hasOption("d") || cmd.hasOption("verification-details")) {
                    verificationDetails = true;
                }
                if (cmd.hasOption("tables")) {
                    String tableNameListStr = cmd.getOptionValue("tables");
                    String[] tableNames = StringUtils.split((String)tableNameListStr, (String)",");
                    rp.setTargetTableName(tableNames);
                }
                if (cmd.hasOption("munkres")) {
                    USE_MUNKRES_FOR_PLACING_SECONDARY_AND_TERTIARY = true;
                }
                if (cmd.hasOption("v") || cmd.hasOption("verify")) {
                    rp.verifyRegionPlacement(verificationDetails);
                    break block23;
                }
                if (cmd.hasOption("n") || cmd.hasOption("dry-run")) {
                    plan = rp.getNewAssignmentPlan();
                    RegionPlacementMaintainer.printAssignmentPlan(plan);
                    break block23;
                }
                if (cmd.hasOption("w") || cmd.hasOption("write")) {
                    plan = rp.getNewAssignmentPlan();
                    RegionPlacementMaintainer.printAssignmentPlan(plan);
                    rp.updateAssignmentPlanToMeta(plan);
                    break block23;
                }
                if (cmd.hasOption("u") || cmd.hasOption("update")) {
                    plan = rp.getNewAssignmentPlan();
                    RegionPlacementMaintainer.printAssignmentPlan(plan);
                    rp.updateAssignmentPlan(plan);
                    break block23;
                }
                if (cmd.hasOption("diff")) {
                    FavoredNodesPlan newPlan = rp.getNewAssignmentPlan();
                    Map<String, Map<String, Float>> locality = FSUtils.getRegionDegreeLocalityMappingFromFS(conf);
                    Map<TableName, Integer> movesPerTable = rp.getRegionsMovement(newPlan);
                    rp.checkDifferencesWithOldPlan(movesPerTable, locality, newPlan);
                    System.out.println("Do you want to update the assignment plan? [y/n]");
                    Scanner s = new Scanner(System.in);
                    String input = s.nextLine().trim();
                    if (input.equals("y")) {
                        System.out.println("Updating assignment plan...");
                        rp.updateAssignmentPlan(newPlan);
                    }
                    s.close();
                    break block23;
                }
                if (cmd.hasOption("ld")) {
                    Map<String, Map<String, Float>> locality = FSUtils.getRegionDegreeLocalityMappingFromFS(conf);
                    rp.printLocalityAndDispersionForCurrentPlan(locality);
                    break block23;
                }
                if (cmd.hasOption("p") || cmd.hasOption("print")) {
                    plan = rp.getRegionAssignmentSnapshot().getExistingAssignmentPlan();
                    RegionPlacementMaintainer.printAssignmentPlan(plan);
                    break block23;
                }
                if (cmd.hasOption("overwrite")) {
                    if (!cmd.hasOption("f") || !cmd.hasOption("r")) {
                        throw new IllegalArgumentException("Please specify:  -update -r regionName -f server1:port,server2:port,server3:port");
                    }
                    String regionName = cmd.getOptionValue("r");
                    String favoredNodesStr = cmd.getOptionValue("f");
                    LOG.info((Object)("Going to update the region " + regionName + " with the new favored nodes " + favoredNodesStr));
                    List<ServerName> favoredNodes = null;
                    HRegionInfo regionInfo = rp.getRegionAssignmentSnapshot().getRegionNameToRegionInfoMap().get(regionName);
                    if (regionInfo == null) {
                        LOG.error((Object)("Cannot find the region " + regionName + " from the META"));
                        break block23;
                    }
                    try {
                        favoredNodes = RegionPlacementMaintainer.getFavoredNodeList(favoredNodesStr);
                    }
                    catch (IllegalArgumentException e) {
                        LOG.error((Object)("Cannot parse the invalid favored nodes because " + e));
                    }
                    FavoredNodesPlan newPlan = new FavoredNodesPlan();
                    newPlan.updateAssignmentPlan(regionInfo, favoredNodes);
                    rp.updateAssignmentPlan(newPlan);
                    break block23;
                }
                RegionPlacementMaintainer.printHelp(opt);
            }
            catch (ParseException e) {
                RegionPlacementMaintainer.printHelp(opt);
            }
        }
    }

    protected static class RandomizedMatrix {
        private final int rows;
        private final int cols;
        private final int[] rowTransform;
        private final int[] rowInverse;
        private final int[] colTransform;
        private final int[] colInverse;

        public RandomizedMatrix(int rows, int cols) {
            int temp;
            int r;
            int i;
            this.rows = rows;
            this.cols = cols;
            Random random = new Random();
            this.rowTransform = new int[rows];
            this.rowInverse = new int[rows];
            for (i = 0; i < rows; ++i) {
                this.rowTransform[i] = i;
            }
            for (i = rows - 1; i >= 0; --i) {
                r = random.nextInt(i + 1);
                temp = this.rowTransform[r];
                this.rowTransform[r] = this.rowTransform[i];
                this.rowTransform[i] = temp;
            }
            for (i = 0; i < rows; ++i) {
                this.rowInverse[this.rowTransform[i]] = i;
            }
            this.colTransform = new int[cols];
            this.colInverse = new int[cols];
            for (i = 0; i < cols; ++i) {
                this.colTransform[i] = i;
            }
            for (i = cols - 1; i >= 0; --i) {
                r = random.nextInt(i + 1);
                temp = this.colTransform[r];
                this.colTransform[r] = this.colTransform[i];
                this.colTransform[i] = temp;
            }
            for (i = 0; i < cols; ++i) {
                this.colInverse[this.colTransform[i]] = i;
            }
        }

        public float[][] transform(float[][] matrix) {
            float[][] result = new float[this.rows][this.cols];
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.cols; ++j) {
                    result[this.rowTransform[i]][this.colTransform[j]] = matrix[i][j];
                }
            }
            return result;
        }

        public float[][] invert(float[][] matrix) {
            float[][] result = new float[this.rows][this.cols];
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.cols; ++j) {
                    result[this.rowInverse[i]][this.colInverse[j]] = matrix[i][j];
                }
            }
            return result;
        }

        public int[] invertIndices(int[] indices) {
            int[] result = new int[indices.length];
            for (int i = 0; i < indices.length; ++i) {
                result[this.rowInverse[i]] = this.colInverse[indices[i]];
            }
            return result;
        }
    }
}

