/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master.balancer;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.HConstants;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.client.Connection;
import org.apache.hudi.org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hudi.org.apache.hadoop.hbase.client.Put;
import org.apache.hudi.org.apache.hadoop.hbase.client.Table;
import org.apache.hudi.org.apache.hadoop.hbase.master.RackManager;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
public class FavoredNodeAssignmentHelper {
    private static final Log LOG = LogFactory.getLog(FavoredNodeAssignmentHelper.class);
    private RackManager rackManager;
    private Map<String, List<ServerName>> rackToRegionServerMap;
    private List<String> uniqueRackList;
    private Map<ServerName, String> regionServerToRackMap;
    private Random random;
    private List<ServerName> servers;
    public static final byte[] FAVOREDNODES_QUALIFIER = Bytes.toBytes("fn");
    public static final short FAVORED_NODES_NUM = 3;

    public FavoredNodeAssignmentHelper(List<ServerName> servers, Configuration conf) {
        this(servers, new RackManager(conf));
    }

    public FavoredNodeAssignmentHelper(List<ServerName> servers, RackManager rackManager) {
        this.servers = servers;
        this.rackManager = rackManager;
        this.rackToRegionServerMap = new HashMap<String, List<ServerName>>();
        this.regionServerToRackMap = new HashMap<ServerName, String>();
        this.uniqueRackList = new ArrayList<String>();
        this.random = new Random();
    }

    public static void updateMetaWithFavoredNodesInfo(Map<HRegionInfo, List<ServerName>> regionToFavoredNodes, Connection connection) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (Map.Entry<HRegionInfo, List<ServerName>> entry : regionToFavoredNodes.entrySet()) {
            Put put = FavoredNodeAssignmentHelper.makePutFromRegionInfo(entry.getKey(), entry.getValue());
            if (put == null) continue;
            puts.add(put);
        }
        MetaTableAccessor.putsToMetaTable(connection, puts);
        LOG.info((Object)("Added " + puts.size() + " regions in META"));
    }

    public static void updateMetaWithFavoredNodesInfo(Map<HRegionInfo, List<ServerName>> regionToFavoredNodes, Configuration conf) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (Map.Entry<HRegionInfo, List<ServerName>> entry : regionToFavoredNodes.entrySet()) {
            Put put = FavoredNodeAssignmentHelper.makePutFromRegionInfo(entry.getKey(), entry.getValue());
            if (put == null) continue;
            puts.add(put);
        }
        try (Connection connection = ConnectionFactory.createConnection(conf);
             Table metaTable = connection.getTable(TableName.META_TABLE_NAME);){
            metaTable.put(puts);
        }
        LOG.info((Object)("Added " + puts.size() + " regions in META"));
    }

    static Put makePutFromRegionInfo(HRegionInfo regionInfo, List<ServerName> favoredNodeList) throws IOException {
        Put put = null;
        if (favoredNodeList != null) {
            put = MetaTableAccessor.makePutFromRegionInfo(regionInfo);
            byte[] favoredNodes = FavoredNodeAssignmentHelper.getFavoredNodes(favoredNodeList);
            put.addImmutable(HConstants.CATALOG_FAMILY, FAVOREDNODES_QUALIFIER, EnvironmentEdgeManager.currentTime(), favoredNodes);
            LOG.info((Object)("Create the region " + regionInfo.getRegionNameAsString() + " with favored nodes " + Bytes.toString(favoredNodes)));
        }
        return put;
    }

    public static ServerName[] getFavoredNodesList(byte[] favoredNodes) throws InvalidProtocolBufferException {
        HBaseProtos.FavoredNodes f = HBaseProtos.FavoredNodes.parseFrom(favoredNodes);
        List<HBaseProtos.ServerName> protoNodes = f.getFavoredNodeList();
        ServerName[] servers = new ServerName[protoNodes.size()];
        int i = 0;
        for (HBaseProtos.ServerName node : protoNodes) {
            servers[i++] = ProtobufUtil.toServerName(node);
        }
        return servers;
    }

    public static byte[] getFavoredNodes(List<ServerName> serverAddrList) {
        HBaseProtos.FavoredNodes.Builder f = HBaseProtos.FavoredNodes.newBuilder();
        for (ServerName s : serverAddrList) {
            HBaseProtos.ServerName.Builder b = HBaseProtos.ServerName.newBuilder();
            b.setHostName(s.getHostname());
            b.setPort(s.getPort());
            b.setStartCode(s.getStartcode());
            f.addFavoredNode(b.build());
        }
        return f.build().toByteArray();
    }

    void placePrimaryRSAsRoundRobin(Map<ServerName, List<HRegionInfo>> assignmentMap, Map<HRegionInfo, ServerName> primaryRSMap, List<HRegionInfo> regions) {
        int firstServerIndex;
        ArrayList<String> rackList = new ArrayList<String>(this.rackToRegionServerMap.size());
        rackList.addAll(this.rackToRegionServerMap.keySet());
        int rackIndex = this.random.nextInt(rackList.size());
        int maxRackSize = 0;
        for (Map.Entry<String, List<ServerName>> r : this.rackToRegionServerMap.entrySet()) {
            if (r.getValue().size() <= maxRackSize) continue;
            maxRackSize = r.getValue().size();
        }
        int numIterations = 0;
        int serverIndex = firstServerIndex = this.random.nextInt(maxRackSize);
        for (HRegionInfo regionInfo : regions) {
            List<ServerName> currentServerList;
            while (true) {
                String rackName = (String)rackList.get(rackIndex);
                ++numIterations;
                currentServerList = this.rackToRegionServerMap.get(rackName);
                if (serverIndex < currentServerList.size()) break;
                if (numIterations % rackList.size() == 0 && ++serverIndex >= maxRackSize) {
                    serverIndex = 0;
                }
                if (++rackIndex < rackList.size()) continue;
                rackIndex = 0;
            }
            ServerName currentServer = currentServerList.get(serverIndex);
            primaryRSMap.put(regionInfo, currentServer);
            List<HRegionInfo> regionsForServer = assignmentMap.get(currentServer);
            if (regionsForServer == null) {
                regionsForServer = new ArrayList<HRegionInfo>();
                assignmentMap.put(currentServer, regionsForServer);
            }
            regionsForServer.add(regionInfo);
            if (numIterations % rackList.size() == 0) {
                ++serverIndex;
            }
            if (++rackIndex < rackList.size()) continue;
            rackIndex = 0;
        }
    }

    Map<HRegionInfo, ServerName[]> placeSecondaryAndTertiaryRS(Map<HRegionInfo, ServerName> primaryRSMap) {
        HashMap<HRegionInfo, ServerName[]> secondaryAndTertiaryMap = new HashMap<HRegionInfo, ServerName[]>();
        for (Map.Entry<HRegionInfo, ServerName> entry : primaryRSMap.entrySet()) {
            HRegionInfo regionInfo = entry.getKey();
            ServerName primaryRS = entry.getValue();
            try {
                String primaryRack = this.rackManager.getRack(primaryRS);
                ServerName[] favoredNodes = this.getTotalNumberOfRacks() == 1 ? this.singleRackCase(regionInfo, primaryRS, primaryRack) : this.multiRackCase(regionInfo, primaryRS, primaryRack);
                if (favoredNodes == null) continue;
                secondaryAndTertiaryMap.put(regionInfo, favoredNodes);
                LOG.debug((Object)("Place the secondary and tertiary region server for region " + regionInfo.getRegionNameAsString()));
            }
            catch (Exception e) {
                LOG.warn((Object)("Cannot place the favored nodes for region " + regionInfo.getRegionNameAsString() + " because " + e), (Throwable)e);
            }
        }
        return secondaryAndTertiaryMap;
    }

    private Map<ServerName, Set<HRegionInfo>> mapRSToPrimaries(Map<HRegionInfo, ServerName> primaryRSMap) {
        HashMap<ServerName, Set<HRegionInfo>> primaryServerMap = new HashMap<ServerName, Set<HRegionInfo>>();
        for (Map.Entry<HRegionInfo, ServerName> e : primaryRSMap.entrySet()) {
            HashSet<HRegionInfo> currentSet = (HashSet<HRegionInfo>)primaryServerMap.get(e.getValue());
            if (currentSet == null) {
                currentSet = new HashSet<HRegionInfo>();
            }
            currentSet.add(e.getKey());
            primaryServerMap.put(e.getValue(), currentSet);
        }
        return primaryServerMap;
    }

    public Map<HRegionInfo, ServerName[]> placeSecondaryAndTertiaryWithRestrictions(Map<HRegionInfo, ServerName> primaryRSMap) {
        Map<ServerName, Set<HRegionInfo>> serverToPrimaries = this.mapRSToPrimaries(primaryRSMap);
        HashMap<HRegionInfo, ServerName[]> secondaryAndTertiaryMap = new HashMap<HRegionInfo, ServerName[]>();
        for (Map.Entry<HRegionInfo, ServerName> entry : primaryRSMap.entrySet()) {
            HRegionInfo regionInfo = entry.getKey();
            ServerName primaryRS = entry.getValue();
            try {
                String primaryRack = this.rackManager.getRack(primaryRS);
                ServerName[] favoredNodes = null;
                favoredNodes = this.getTotalNumberOfRacks() == 1 ? this.singleRackCase(regionInfo, primaryRS, primaryRack) : this.multiRackCaseWithRestrictions(serverToPrimaries, secondaryAndTertiaryMap, primaryRack, primaryRS, regionInfo);
                if (favoredNodes == null) continue;
                secondaryAndTertiaryMap.put(regionInfo, favoredNodes);
                LOG.debug((Object)("Place the secondary and tertiary region server for region " + regionInfo.getRegionNameAsString()));
            }
            catch (Exception e) {
                LOG.warn((Object)("Cannot place the favored nodes for region " + regionInfo.getRegionNameAsString() + " because " + e), (Throwable)e);
            }
        }
        return secondaryAndTertiaryMap;
    }

    private ServerName[] multiRackCaseWithRestrictions(Map<ServerName, Set<HRegionInfo>> serverToPrimaries, Map<HRegionInfo, ServerName[]> secondaryAndTertiaryMap, String primaryRack, ServerName primaryRS, HRegionInfo regionInfo) throws IOException {
        ServerName[] favoredNodes;
        HashSet<String> rackSkipSet = new HashSet<String>();
        rackSkipSet.add(primaryRack);
        String secondaryRack = this.getOneRandomRack(rackSkipSet);
        List<ServerName> serverList = this.getServersFromRack(secondaryRack);
        HashSet<ServerName> serverSet = new HashSet<ServerName>();
        serverSet.addAll(serverList);
        if (serverList.size() >= 2) {
            Set<HRegionInfo> primaries = serverToPrimaries.get(primaryRS);
            HashSet<ServerName> skipServerSet = new HashSet<ServerName>();
            while (true) {
                ServerName[] secondaryAndTertiary = null;
                if (primaries.size() > 1) {
                    for (HRegionInfo primary : primaries) {
                        secondaryAndTertiary = secondaryAndTertiaryMap.get(primary);
                        if (secondaryAndTertiary == null) continue;
                        if (this.regionServerToRackMap.get(secondaryAndTertiary[0]).equals(secondaryRack)) {
                            skipServerSet.add(secondaryAndTertiary[0]);
                        }
                        if (!this.regionServerToRackMap.get(secondaryAndTertiary[1]).equals(secondaryRack)) continue;
                        skipServerSet.add(secondaryAndTertiary[1]);
                    }
                }
                if (skipServerSet.size() + 2 <= serverSet.size()) break;
                skipServerSet.clear();
                rackSkipSet.add(secondaryRack);
                if (rackSkipSet.size() == this.getTotalNumberOfRacks()) {
                    skipServerSet.remove(secondaryAndTertiary[0]);
                    skipServerSet.remove(secondaryAndTertiary[1]);
                    break;
                }
                secondaryRack = this.getOneRandomRack(rackSkipSet);
                serverList = this.getServersFromRack(secondaryRack);
                serverSet = new HashSet();
                serverSet.addAll(serverList);
            }
            ServerName secondaryRS = this.getOneRandomServer(secondaryRack, skipServerSet);
            skipServerSet.add(secondaryRS);
            ServerName tertiaryRS = this.getOneRandomServer(secondaryRack, skipServerSet);
            if (secondaryRS == null || tertiaryRS == null) {
                LOG.error((Object)("Cannot place the secondary and tertiary region server for region " + regionInfo.getRegionNameAsString()));
            }
            favoredNodes = new ServerName[]{secondaryRS, tertiaryRS};
        } else {
            ServerName secondary;
            favoredNodes = new ServerName[2];
            favoredNodes[0] = secondary = this.getOneRandomServer(secondaryRack);
            if (this.getTotalNumberOfRacks() == 2) {
                HashSet<ServerName> serverSkipSet = new HashSet<ServerName>();
                serverSkipSet.add(primaryRS);
                favoredNodes[1] = this.getOneRandomServer(primaryRack, serverSkipSet);
            } else {
                rackSkipSet.add(secondaryRack);
                String tertiaryRandomRack = this.getOneRandomRack(rackSkipSet);
                favoredNodes[1] = this.getOneRandomServer(tertiaryRandomRack);
            }
        }
        return favoredNodes;
    }

    private ServerName[] singleRackCase(HRegionInfo regionInfo, ServerName primaryRS, String primaryRack) throws IOException {
        List<ServerName> serverList = this.getServersFromRack(primaryRack);
        if (serverList.size() <= 2) {
            return null;
        }
        HashSet<ServerName> serverSkipSet = new HashSet<ServerName>();
        serverSkipSet.add(primaryRS);
        ServerName secondaryRS = this.getOneRandomServer(primaryRack, serverSkipSet);
        serverSkipSet.add(secondaryRS);
        ServerName tertiaryRS = this.getOneRandomServer(primaryRack, serverSkipSet);
        if (secondaryRS == null || tertiaryRS == null) {
            LOG.error((Object)("Cannot place the secondary and terinaryregion server for region " + regionInfo.getRegionNameAsString()));
        }
        ServerName[] favoredNodes = new ServerName[]{secondaryRS, tertiaryRS};
        return favoredNodes;
    }

    private ServerName[] multiRackCase(HRegionInfo regionInfo, ServerName primaryRS, String primaryRack) throws IOException {
        HashSet<String> rackSkipSet = new HashSet<String>();
        rackSkipSet.add(primaryRack);
        ServerName[] favoredNodes = new ServerName[2];
        String secondaryRack = this.getOneRandomRack(rackSkipSet);
        List<ServerName> serverList = this.getServersFromRack(secondaryRack);
        if (serverList.size() >= 2) {
            ServerName secondaryRS = this.getOneRandomServer(secondaryRack);
            HashSet<ServerName> skipServerSet = new HashSet<ServerName>();
            skipServerSet.add(secondaryRS);
            ServerName tertiaryRS = this.getOneRandomServer(secondaryRack, skipServerSet);
            if (secondaryRS == null || tertiaryRS == null) {
                LOG.error((Object)("Cannot place the secondary and terinaryregion server for region " + regionInfo.getRegionNameAsString()));
            }
            favoredNodes[0] = secondaryRS;
            favoredNodes[1] = tertiaryRS;
        } else {
            favoredNodes[0] = this.getOneRandomServer(secondaryRack);
            if (this.getTotalNumberOfRacks() == 2) {
                HashSet<ServerName> serverSkipSet = new HashSet<ServerName>();
                serverSkipSet.add(primaryRS);
                favoredNodes[1] = this.getOneRandomServer(primaryRack, serverSkipSet);
            } else {
                rackSkipSet.add(secondaryRack);
                String tertiaryRandomRack = this.getOneRandomRack(rackSkipSet);
                favoredNodes[1] = this.getOneRandomServer(tertiaryRandomRack);
            }
        }
        return favoredNodes;
    }

    boolean canPlaceFavoredNodes() {
        int serverSize = this.regionServerToRackMap.size();
        return serverSize >= 3;
    }

    public void initialize() {
        for (ServerName sn : this.servers) {
            String rackName = this.rackManager.getRack(sn);
            List<ServerName> serverList = this.rackToRegionServerMap.get(rackName);
            if (serverList == null) {
                serverList = new ArrayList<ServerName>();
                this.uniqueRackList.add(rackName);
            }
            if (serverList.contains(sn)) continue;
            serverList.add(sn);
            this.rackToRegionServerMap.put(rackName, serverList);
            this.regionServerToRackMap.put(sn, rackName);
        }
    }

    private int getTotalNumberOfRacks() {
        return this.uniqueRackList.size();
    }

    private List<ServerName> getServersFromRack(String rack) {
        return this.rackToRegionServerMap.get(rack);
    }

    private ServerName getOneRandomServer(String rack, Set<ServerName> skipServerSet) throws IOException {
        ServerName randomServer;
        if (rack == null) {
            return null;
        }
        List<ServerName> serverList = this.rackToRegionServerMap.get(rack);
        if (serverList == null) {
            return null;
        }
        if (skipServerSet != null && serverList.size() <= skipServerSet.size()) {
            throw new IOException("Cannot randomly pick another random server");
        }
        do {
            int randomIndex = this.random.nextInt(serverList.size());
            randomServer = serverList.get(randomIndex);
        } while (skipServerSet != null && skipServerSet.contains(randomServer));
        return randomServer;
    }

    private ServerName getOneRandomServer(String rack) throws IOException {
        return this.getOneRandomServer(rack, null);
    }

    private String getOneRandomRack(Set<String> skipRackSet) throws IOException {
        int randomIndex;
        String randomRack;
        if (skipRackSet == null || this.uniqueRackList.size() <= skipRackSet.size()) {
            throw new IOException("Cannot randomly pick another random server");
        }
        while (skipRackSet.contains(randomRack = this.uniqueRackList.get(randomIndex = this.random.nextInt(this.uniqueRackList.size())))) {
        }
        return randomRack;
    }

    public static String getFavoredNodesAsString(List<ServerName> nodes) {
        StringBuffer strBuf = new StringBuffer();
        int i = 0;
        for (ServerName node : nodes) {
            strBuf.append(node.getHostAndPort());
            if (++i == nodes.size()) continue;
            strBuf.append(";");
        }
        return strBuf.toString();
    }
}

