/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.quotas;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.DefaultOperationQuota;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.NoopOperationQuota;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.OperationQuota;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.QuotaCache;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.QuotaLimiter;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.ThrottlingException;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.UserQuotaState;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hudi.org.apache.hadoop.hbase.security.User;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class RegionServerQuotaManager {
    private static final Log LOG = LogFactory.getLog(RegionServerQuotaManager.class);
    private final RegionServerServices rsServices;
    private QuotaCache quotaCache = null;

    public RegionServerQuotaManager(RegionServerServices rsServices) {
        this.rsServices = rsServices;
    }

    public void start(RpcScheduler rpcScheduler) throws IOException {
        if (!QuotaUtil.isQuotaEnabled(this.rsServices.getConfiguration())) {
            LOG.info((Object)"Quota support disabled");
            return;
        }
        LOG.info((Object)"Initializing quota support");
        this.quotaCache = new QuotaCache(this.rsServices);
        this.quotaCache.start();
    }

    public void stop() {
        if (this.isQuotaEnabled()) {
            this.quotaCache.stop("shutdown");
        }
    }

    public boolean isQuotaEnabled() {
        return this.quotaCache != null;
    }

    @VisibleForTesting
    QuotaCache getQuotaCache() {
        return this.quotaCache;
    }

    public OperationQuota getQuota(UserGroupInformation ugi, TableName table) {
        if (this.isQuotaEnabled() && !table.isSystemTable()) {
            UserQuotaState userQuotaState = this.quotaCache.getUserQuotaState(ugi);
            QuotaLimiter userLimiter = userQuotaState.getTableLimiter(table);
            boolean useNoop = userLimiter.isBypass();
            if (userQuotaState.hasBypassGlobals()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("get quota for ugi=" + ugi + " table=" + table + " userLimiter=" + userLimiter));
                }
                if (!useNoop) {
                    return new DefaultOperationQuota(userLimiter);
                }
            } else {
                QuotaLimiter nsLimiter = this.quotaCache.getNamespaceLimiter(table.getNamespaceAsString());
                QuotaLimiter tableLimiter = this.quotaCache.getTableLimiter(table);
                useNoop &= tableLimiter.isBypass() && nsLimiter.isBypass();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("get quota for ugi=" + ugi + " table=" + table + " userLimiter=" + userLimiter + " tableLimiter=" + tableLimiter + " nsLimiter=" + nsLimiter));
                }
                if (!useNoop) {
                    return new DefaultOperationQuota(userLimiter, tableLimiter, nsLimiter);
                }
            }
        }
        return NoopOperationQuota.get();
    }

    public OperationQuota checkQuota(Region region, OperationQuota.OperationType type) throws IOException, ThrottlingException {
        switch (type) {
            case SCAN: {
                return this.checkQuota(region, 0, 0, 1);
            }
            case GET: {
                return this.checkQuota(region, 0, 1, 0);
            }
            case MUTATE: {
                return this.checkQuota(region, 1, 0, 0);
            }
        }
        throw new RuntimeException("Invalid operation type: " + (Object)((Object)type));
    }

    public OperationQuota checkQuota(Region region, List<ClientProtos.Action> actions) throws IOException, ThrottlingException {
        int numWrites = 0;
        int numReads = 0;
        for (ClientProtos.Action action : actions) {
            if (action.hasMutation()) {
                ++numWrites;
                continue;
            }
            if (!action.hasGet()) continue;
            ++numReads;
        }
        return this.checkQuota(region, numWrites, numReads, 0);
    }

    private OperationQuota checkQuota(Region region, int numWrites, int numReads, int numScans) throws IOException, ThrottlingException {
        User user = RpcServer.getRequestUser();
        UserGroupInformation ugi = user != null ? user.getUGI() : User.getCurrent().getUGI();
        TableName table = region.getTableDesc().getTableName();
        OperationQuota quota = this.getQuota(ugi, table);
        try {
            quota.checkQuota(numWrites, numReads, numScans);
        }
        catch (ThrottlingException e) {
            LOG.debug((Object)("Throttling exception for user=" + ugi.getUserName() + " table=" + table + " numWrites=" + numWrites + " numReads=" + numReads + " numScans=" + numScans + ": " + e.getMessage()));
            throw e;
        }
        return quota;
    }
}

