/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hudi.org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.MetricsRegionServerSource;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;

@InterfaceStability.Evolving
@InterfaceAudience.Private
public class MetricsRegionServer {
    private MetricsRegionServerSource serverSource;
    private MetricsRegionServerWrapper regionServerWrapper;

    public MetricsRegionServer(MetricsRegionServerWrapper regionServerWrapper) {
        this(regionServerWrapper, ((MetricsRegionServerSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class)).createServer(regionServerWrapper));
    }

    MetricsRegionServer(MetricsRegionServerWrapper regionServerWrapper, MetricsRegionServerSource serverSource) {
        this.regionServerWrapper = regionServerWrapper;
        this.serverSource = serverSource;
    }

    @VisibleForTesting
    public MetricsRegionServerSource getMetricsSource() {
        return this.serverSource;
    }

    public MetricsRegionServerWrapper getRegionServerWrapper() {
        return this.regionServerWrapper;
    }

    public void updatePut(long t) {
        if (t > 1000L) {
            this.serverSource.incrSlowPut();
        }
        this.serverSource.updatePut(t);
    }

    public void updateDelete(long t) {
        if (t > 1000L) {
            this.serverSource.incrSlowDelete();
        }
        this.serverSource.updateDelete(t);
    }

    public void updateGet(long t) {
        if (t > 1000L) {
            this.serverSource.incrSlowGet();
        }
        this.serverSource.updateGet(t);
    }

    public void updateIncrement(long t) {
        if (t > 1000L) {
            this.serverSource.incrSlowIncrement();
        }
        this.serverSource.updateIncrement(t);
    }

    public void updateAppend(long t) {
        if (t > 1000L) {
            this.serverSource.incrSlowAppend();
        }
        this.serverSource.updateAppend(t);
    }

    public void updateReplay(long t) {
        this.serverSource.updateReplay(t);
    }

    public void updateScannerNext(long scanSize) {
        this.serverSource.updateScannerNext(scanSize);
    }

    public void updateSplitTime(long t) {
        this.serverSource.updateSplitTime(t);
    }

    public void incrSplitRequest() {
        this.serverSource.incrSplitRequest();
    }

    public void incrSplitSuccess() {
        this.serverSource.incrSplitSuccess();
    }

    public void updateFlushTime(long t) {
        this.serverSource.updateFlushTime(t);
    }
}

