/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.Coprocessor;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.WALCoprocessorEnvironment;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.WALObserver;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hudi.org.apache.hadoop.hbase.wal.WAL;
import org.apache.hudi.org.apache.hadoop.hbase.wal.WALKey;

@InterfaceAudience.Private
public class WALCoprocessorHost
extends CoprocessorHost<WALEnvironment> {
    private final WAL wal;

    public WALCoprocessorHost(WAL log, Configuration conf) {
        super(null);
        this.wal = log;
        this.loadSystemCoprocessors(conf, "hbase.coprocessor.wal.classes");
    }

    @Override
    public WALEnvironment createEnvironment(Class<?> implClass, Coprocessor instance, int priority, int seq, Configuration conf) {
        return new WALEnvironment(implClass, instance, priority, seq, conf, this.wal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preWALWrite(HRegionInfo info, WALKey logKey, WALEdit logEdit) throws IOException {
        boolean bypass = false;
        if (this.coprocessors == null || this.coprocessors.isEmpty()) {
            return bypass;
        }
        ObserverContext<WALCoprocessorEnvironment> ctx = null;
        List envs = this.coprocessors.get();
        for (int i = 0; i < envs.size(); ++i) {
            WALEnvironment env = (WALEnvironment)envs.get(i);
            if (!(env.getInstance() instanceof WALObserver)) continue;
            WALObserver observer = (WALObserver)env.getInstance();
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                if (env.useLegacyPre) {
                    if (logKey instanceof HLogKey) {
                        observer.preWALWrite(ctx, info, (HLogKey)logKey, logEdit);
                    } else {
                        this.legacyWarning(observer.getClass(), "There are wal keys present that are not HLogKey.");
                    }
                } else {
                    observer.preWALWrite(ctx, info, logKey, logEdit);
                }
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            bypass |= ctx.shouldBypass();
            if (ctx.shouldComplete()) break;
        }
        return bypass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postWALWrite(HRegionInfo info, WALKey logKey, WALEdit logEdit) throws IOException {
        if (this.coprocessors == null || this.coprocessors.isEmpty()) {
            return;
        }
        ObserverContext<WALCoprocessorEnvironment> ctx = null;
        List envs = this.coprocessors.get();
        for (int i = 0; i < envs.size(); ++i) {
            WALEnvironment env = (WALEnvironment)envs.get(i);
            if (!(env.getInstance() instanceof WALObserver)) continue;
            WALObserver observer = (WALObserver)env.getInstance();
            ctx = ObserverContext.createAndPrepare(env, ctx);
            Thread currentThread = Thread.currentThread();
            ClassLoader cl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(env.getClassLoader());
                if (env.useLegacyPost) {
                    if (logKey instanceof HLogKey) {
                        observer.postWALWrite(ctx, info, (HLogKey)logKey, logEdit);
                    } else {
                        this.legacyWarning(observer.getClass(), "There are wal keys present that are not HLogKey.");
                    }
                } else {
                    observer.postWALWrite(ctx, info, logKey, logEdit);
                }
            }
            catch (Throwable e) {
                this.handleCoprocessorThrowable(env, e);
            }
            finally {
                currentThread.setContextClassLoader(cl);
            }
            if (ctx.shouldComplete()) break;
        }
    }

    static class WALEnvironment
    extends CoprocessorHost.Environment
    implements WALCoprocessorEnvironment {
        private final WAL wal;
        final boolean useLegacyPre;
        final boolean useLegacyPost;

        @Override
        public WAL getWAL() {
            return this.wal;
        }

        public WALEnvironment(Class<?> implClass, Coprocessor impl, int priority, int seq, Configuration conf, WAL wal) {
            super(impl, priority, seq, conf);
            this.wal = wal;
            this.useLegacyPre = WALCoprocessorHost.useLegacyMethod(impl.getClass(), "preWALWrite", new Class[]{ObserverContext.class, HRegionInfo.class, WALKey.class, WALEdit.class});
            this.useLegacyPost = WALCoprocessorHost.useLegacyMethod(impl.getClass(), "postWALWrite", new Class[]{ObserverContext.class, HRegionInfo.class, WALKey.class, WALEdit.class});
        }
    }
}

