/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hudi.org.apache.hadoop.hbase.types.OrderedBytesBase;
import org.apache.hudi.org.apache.hadoop.hbase.util.Order;
import org.apache.hudi.org.apache.hadoop.hbase.util.OrderedBytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.hudi.org.apache.hadoop.hbase.util.SimplePositionedMutableByteRange;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class OrderedNumeric
extends OrderedBytesBase<Number> {
    public static final OrderedNumeric ASCENDING = new OrderedNumeric(Order.ASCENDING);
    public static final OrderedNumeric DESCENDING = new OrderedNumeric(Order.DESCENDING);

    protected OrderedNumeric(Order order) {
        super(order);
    }

    @Override
    public int encodedLength(Number val) {
        SimplePositionedMutableByteRange buff = new SimplePositionedMutableByteRange(100);
        return this.encode((PositionedByteRange)buff, val);
    }

    @Override
    public Class<Number> encodedClass() {
        return Number.class;
    }

    @Override
    public Number decode(PositionedByteRange src) {
        if (OrderedBytes.isNumericInfinite(src) || OrderedBytes.isNumericNaN(src)) {
            return OrderedBytes.decodeNumericAsDouble(src);
        }
        return OrderedBytes.decodeNumericAsBigDecimal(src);
    }

    @Override
    public int encode(PositionedByteRange dst, Number val) {
        if (null == val) {
            return OrderedBytes.encodeNull(dst, this.order);
        }
        if (val instanceof BigDecimal) {
            return OrderedBytes.encodeNumeric(dst, (BigDecimal)val, this.order);
        }
        if (val instanceof BigInteger) {
            return OrderedBytes.encodeNumeric(dst, new BigDecimal((BigInteger)val), this.order);
        }
        if (val instanceof Double || val instanceof Float) {
            return OrderedBytes.encodeNumeric(dst, val.doubleValue(), this.order);
        }
        return OrderedBytes.encodeNumeric(dst, val.longValue(), this.order);
    }

    public long decodeLong(PositionedByteRange src) {
        return OrderedBytes.decodeNumericAsLong(src);
    }

    public int encodeLong(PositionedByteRange dst, long val) {
        return OrderedBytes.encodeNumeric(dst, val, this.order);
    }

    public double decodeDouble(PositionedByteRange src) {
        return OrderedBytes.decodeNumericAsLong(src);
    }

    public int encodeDouble(PositionedByteRange dst, double val) {
        return OrderedBytes.encodeNumeric(dst, val, this.order);
    }
}

