/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import java.util.ArrayList;
import org.apache.hudi.org.apache.hadoop.hbase.KeyValue;
import org.apache.hudi.org.apache.hadoop.hbase.Tag;
import org.apache.hudi.org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.hudi.org.apache.hadoop.hbase.util.SimplePositionedMutableByteRange;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestByteRangeWithKVSerialization {
    static void writeCell(PositionedByteRange pbr, KeyValue kv) throws Exception {
        pbr.putInt(kv.getKeyLength());
        pbr.putInt(kv.getValueLength());
        pbr.put(kv.getBuffer(), kv.getKeyOffset(), kv.getKeyLength());
        pbr.put(kv.getBuffer(), kv.getValueOffset(), kv.getValueLength());
        int tagsLen = kv.getTagsLength();
        pbr.put((byte)(tagsLen >> 8 & 0xFF));
        pbr.put((byte)(tagsLen & 0xFF));
        pbr.put(kv.getTagsArray(), kv.getTagsOffset(), tagsLen);
        pbr.putVLong(kv.getMvccVersion());
    }

    static KeyValue readCell(PositionedByteRange pbr) throws Exception {
        int kvStartPos = pbr.getPosition();
        int keyLen = pbr.getInt();
        int valLen = pbr.getInt();
        pbr.setPosition(pbr.getPosition() + keyLen + valLen);
        int tagsLen = (pbr.get() & 0xFF) << 8 ^ pbr.get() & 0xFF;
        pbr.setPosition(pbr.getPosition() + tagsLen);
        long mvcc = pbr.getVLong();
        KeyValue kv = new KeyValue(pbr.getBytes(), kvStartPos, (int)KeyValue.getKeyValueDataStructureSize(keyLen, valLen, tagsLen));
        kv.setSequenceId(mvcc);
        return kv;
    }

    @Test
    public void testWritingAndReadingCells() throws Exception {
        byte[] FAMILY = Bytes.toBytes("f1");
        byte[] QUALIFIER = Bytes.toBytes("q1");
        byte[] VALUE = Bytes.toBytes("v");
        int kvCount = 1000000;
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>(kvCount);
        int totalSize = 0;
        Tag[] tags = new Tag[]{new Tag(1, "tag1")};
        for (int i = 0; i < kvCount; ++i) {
            KeyValue kv = new KeyValue(Bytes.toBytes(i), FAMILY, QUALIFIER, (long)i, VALUE, tags);
            kv.setSequenceId(i);
            kvs.add(kv);
            totalSize += kv.getLength() + 8;
        }
        SimplePositionedMutableByteRange pbr = new SimplePositionedMutableByteRange(totalSize);
        for (KeyValue kv : kvs) {
            TestByteRangeWithKVSerialization.writeCell(pbr, kv);
        }
        SimplePositionedMutableByteRange pbr1 = new SimplePositionedMutableByteRange(pbr.getBytes(), 0, pbr.getPosition());
        for (int i = 0; i < kvCount; ++i) {
            KeyValue kv = TestByteRangeWithKVSerialization.readCell(pbr1);
            KeyValue kv1 = (KeyValue)kvs.get(i);
            Assert.assertTrue((boolean)kv.equals(kv1));
            Assert.assertTrue((boolean)Bytes.equals(kv.getValueArray(), kv.getValueOffset(), kv.getValueLength(), kv1.getValueArray(), kv1.getValueOffset(), kv1.getValueLength()));
            Assert.assertTrue((boolean)Bytes.equals(kv.getTagsArray(), kv.getTagsOffset(), kv.getTagsLength(), kv1.getTagsArray(), kv1.getTagsOffset(), kv1.getTagsLength()));
            Assert.assertEquals((long)kv1.getMvccVersion(), (long)kv.getMvccVersion());
        }
    }
}

