/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hudi.org.apache.hadoop.hbase.Abortable;
import org.apache.hudi.org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hudi.org.apache.hadoop.hbase.HConstants;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hudi.org.apache.hadoop.hbase.replication.ReplicationStateZKBase;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class ZKDataMigrator
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(ZKDataMigrator.class);

    @SuppressWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Intended")
    public int run(String[] as) throws Exception {
        Configuration conf = this.getConf();
        try (ZooKeeperWatcher zkw = null;){
            zkw = new ZooKeeperWatcher(this.getConf(), "Migrate ZK data to PB.", new ZKDataMigratorAbortable());
            if (ZKUtil.checkExists(zkw, zkw.baseZNode) == -1) {
                LOG.info((Object)"No hbase related data available in zookeeper. returning..");
                int n = 0;
                return n;
            }
            List<String> children = ZKUtil.listChildrenNoWatch(zkw, zkw.baseZNode);
            if (children == null) {
                LOG.info((Object)"No child nodes to mirgrate. returning..");
                int n = 0;
                return n;
            }
            String childPath = null;
            for (String child : children) {
                childPath = ZKUtil.joinZNode(zkw.baseZNode, child);
                if (child.equals(conf.get("zookeeper.znode.rootserver", "root-region-server"))) {
                    ZKUtil.deleteNodeRecursively(zkw, childPath);
                    continue;
                }
                if (child.equals(conf.get("zookeeper.znode.rs", "rs"))) {
                    ZKUtil.deleteNodeRecursively(zkw, childPath);
                    continue;
                }
                if (child.equals(conf.get("zookeeper.znode.draining.rs", "draining"))) {
                    ZKUtil.deleteNodeRecursively(zkw, childPath);
                    continue;
                }
                if (child.equals(conf.get("zookeeper.znode.master", "master"))) {
                    ZKUtil.deleteNodeRecursively(zkw, childPath);
                    continue;
                }
                if (child.equals(conf.get("zookeeper.znode.backup.masters", "backup-masters"))) {
                    ZKUtil.deleteNodeRecursively(zkw, childPath);
                    continue;
                }
                if (child.equals(conf.get("zookeeper.znode.state", "shutdown"))) {
                    ZKUtil.deleteNodeRecursively(zkw, childPath);
                    continue;
                }
                if (child.equals(conf.get("zookeeper.znode.unassigned", "unassigned"))) {
                    ZKUtil.deleteNodeRecursively(zkw, childPath);
                    continue;
                }
                if (child.equals(conf.get("zookeeper.znode.tableEnableDisable", "table")) || child.equals(conf.get("zookeeper.znode.masterTableEnableDisable", "table"))) {
                    this.checkAndMigrateTableStatesToPB(zkw);
                    continue;
                }
                if (child.equals(conf.get("zookeeper.znode.masterTableEnableDisable92", "table92"))) {
                    ZKUtil.deleteNodeRecursively(zkw, childPath);
                    continue;
                }
                if (child.equals(conf.get("zookeeper.znode.splitlog", "splitlog"))) {
                    ZKUtil.deleteNodeRecursively(zkw, childPath);
                    continue;
                }
                if (child.equals(conf.get("zookeeper.znode.replication", "replication"))) {
                    this.checkAndMigrateReplicationNodesToPB(zkw);
                    continue;
                }
                if (child.equals(conf.get("zookeeper.znode.clusterId", "hbaseid"))) {
                    ZKUtil.deleteNodeRecursively(zkw, childPath);
                    continue;
                }
                if (child.equals("online-snapshot")) {
                    ZKUtil.deleteNodeRecursively(zkw, childPath);
                    continue;
                }
                if (!child.equals(conf.get("zookeeper.znode.acl.parent", "acl"))) continue;
                ZKUtil.deleteNodeRecursively(zkw, childPath);
            }
        }
        return 0;
    }

    private void checkAndMigrateTableStatesToPB(ZooKeeperWatcher zkw) throws KeeperException, InterruptedException {
        List<String> tables = ZKUtil.listChildrenNoWatch(zkw, zkw.tableZNode);
        if (tables == null) {
            LOG.info((Object)"No table present to migrate table state to PB. returning..");
            return;
        }
        for (String table : tables) {
            String znode = ZKUtil.joinZNode(zkw.tableZNode, table);
            if (table.equals("-ROOT-") || table.equals(".META.")) {
                ZKUtil.deleteNode(zkw, znode);
                continue;
            }
            byte[] data = ZKUtil.getData(zkw, znode);
            if (ProtobufUtil.isPBMagicPrefix(data)) continue;
            ZooKeeperProtos.Table.Builder builder = ZooKeeperProtos.Table.newBuilder();
            builder.setState(ZooKeeperProtos.Table.State.valueOf(Bytes.toString(data)));
            data = ProtobufUtil.prependPBMagic(builder.build().toByteArray());
            ZKUtil.setData(zkw, znode, data);
        }
    }

    private void checkAndMigrateReplicationNodesToPB(ZooKeeperWatcher zkw) throws KeeperException, InterruptedException {
        String replicationZnodeName = this.getConf().get("zookeeper.znode.replication", "replication");
        String replicationPath = ZKUtil.joinZNode(zkw.baseZNode, replicationZnodeName);
        List<String> replicationZnodes = ZKUtil.listChildrenNoWatch(zkw, replicationPath);
        if (replicationZnodes == null) {
            LOG.info((Object)"No replication related znodes present to migrate. returning..");
            return;
        }
        for (String child : replicationZnodes) {
            List<String> rsList;
            String znode = ZKUtil.joinZNode(replicationPath, child);
            if (child.equals(this.getConf().get("zookeeper.znode.replication.peers", "peers"))) {
                List<String> peers = ZKUtil.listChildrenNoWatch(zkw, znode);
                if (peers == null || peers.isEmpty()) {
                    LOG.info((Object)"No peers present to migrate. returning..");
                    continue;
                }
                this.checkAndMigratePeerZnodesToPB(zkw, znode, peers);
                continue;
            }
            if (child.equals(this.getConf().get("zookeeper.znode.replication.state", "state"))) {
                ZKUtil.deleteNodeRecursively(zkw, znode);
                continue;
            }
            if (!child.equals(this.getConf().get("zookeeper.znode.replication.rs", "rs")) || (rsList = ZKUtil.listChildrenNoWatch(zkw, znode)) == null || rsList.isEmpty()) continue;
            for (String rs : rsList) {
                this.checkAndMigrateQueuesToPB(zkw, znode, rs);
            }
        }
    }

    private void checkAndMigrateQueuesToPB(ZooKeeperWatcher zkw, String znode, String rs) throws KeeperException, KeeperException.NoNodeException, InterruptedException {
        String rsPath = ZKUtil.joinZNode(znode, rs);
        List<String> peers = ZKUtil.listChildrenNoWatch(zkw, rsPath);
        if (peers == null || peers.isEmpty()) {
            return;
        }
        String peerPath = null;
        for (String peer : peers) {
            peerPath = ZKUtil.joinZNode(rsPath, peer);
            List<String> files = ZKUtil.listChildrenNoWatch(zkw, peerPath);
            if (files == null || files.isEmpty()) continue;
            String filePath = null;
            for (String file : files) {
                filePath = ZKUtil.joinZNode(peerPath, file);
                byte[] data = ZKUtil.getData(zkw, filePath);
                if (data == null || Bytes.equals(data, HConstants.EMPTY_BYTE_ARRAY) || ProtobufUtil.isPBMagicPrefix(data)) continue;
                ZKUtil.setData(zkw, filePath, ZKUtil.positionToByteArray(Long.parseLong(Bytes.toString(data))));
            }
        }
    }

    private void checkAndMigratePeerZnodesToPB(ZooKeeperWatcher zkw, String znode, List<String> peers) throws KeeperException, KeeperException.NoNodeException, InterruptedException {
        for (String peer : peers) {
            String peerStatePath;
            String peerZnode = ZKUtil.joinZNode(znode, peer);
            byte[] data = ZKUtil.getData(zkw, peerZnode);
            if (!ProtobufUtil.isPBMagicPrefix(data)) {
                this.migrateClusterKeyToPB(zkw, peerZnode, data);
            }
            if (ZKUtil.checkExists(zkw, peerStatePath = ZKUtil.joinZNode(peerZnode, this.getConf().get("zookeeper.znode.replication.peers.state", "peer-state"))) == -1 || ProtobufUtil.isPBMagicPrefix(data = ZKUtil.getData(zkw, peerStatePath))) continue;
            this.migratePeerStateToPB(zkw, data, peerStatePath);
        }
    }

    private void migrateClusterKeyToPB(ZooKeeperWatcher zkw, String peerZnode, byte[] data) throws KeeperException, KeeperException.NoNodeException {
        ZooKeeperProtos.ReplicationPeer peer = ZooKeeperProtos.ReplicationPeer.newBuilder().setClusterkey(Bytes.toString(data)).build();
        ZKUtil.setData(zkw, peerZnode, ProtobufUtil.prependPBMagic(peer.toByteArray()));
    }

    private void migratePeerStateToPB(ZooKeeperWatcher zkw, byte[] data, String peerStatePath) throws KeeperException, KeeperException.NoNodeException {
        String state = Bytes.toString(data);
        if (ZooKeeperProtos.ReplicationState.State.ENABLED.name().equals(state)) {
            ZKUtil.setData(zkw, peerStatePath, ReplicationStateZKBase.ENABLED_ZNODE_BYTES);
        } else if (ZooKeeperProtos.ReplicationState.State.DISABLED.name().equals(state)) {
            ZKUtil.setData(zkw, peerStatePath, ReplicationStateZKBase.DISABLED_ZNODE_BYTES);
        }
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new ZKDataMigrator(), (String[])args));
    }

    static class ZKDataMigratorAbortable
    implements Abortable {
        private boolean aborted = false;

        ZKDataMigratorAbortable() {
        }

        @Override
        public void abort(String why, Throwable e) {
            LOG.error((Object)("Got aborted with reason: " + why + ", and error: " + e));
            this.aborted = true;
        }

        @Override
        public boolean isAborted() {
            return this.aborted;
        }
    }
}

