/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.trace;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.trace.HBaseHTraceConfiguration;
import org.apache.htrace.SpanReceiver;
import org.apache.htrace.SpanReceiverBuilder;
import org.apache.htrace.Trace;

@InterfaceAudience.Private
public class SpanReceiverHost {
    public static final String SPAN_RECEIVERS_CONF_KEY = "hbase.trace.spanreceiver.classes";
    private static final Log LOG = LogFactory.getLog(SpanReceiverHost.class);
    private Collection<SpanReceiver> receivers = new HashSet<SpanReceiver>();
    private Configuration conf;
    private boolean closed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpanReceiverHost getInstance(Configuration conf) {
        Object object = SingletonHolder.INSTANCE.lock;
        synchronized (object) {
            if (SingletonHolder.INSTANCE.host != null) {
                return SingletonHolder.INSTANCE.host;
            }
            SpanReceiverHost host = new SpanReceiverHost(conf);
            host.loadSpanReceivers();
            SingletonHolder.INSTANCE.host = host;
            return SingletonHolder.INSTANCE.host;
        }
    }

    SpanReceiverHost(Configuration conf) {
        this.conf = conf;
    }

    public void loadSpanReceivers() {
        String[] receiverNames = this.conf.getStrings(SPAN_RECEIVERS_CONF_KEY);
        if (receiverNames == null || receiverNames.length == 0) {
            return;
        }
        SpanReceiverBuilder builder = new SpanReceiverBuilder(new HBaseHTraceConfiguration(this.conf));
        for (String className : receiverNames) {
            SpanReceiver receiver = builder.spanReceiverClass(className = className.trim()).build();
            if (receiver == null) continue;
            this.receivers.add(receiver);
            LOG.info((Object)("SpanReceiver " + className + " was loaded successfully."));
        }
        for (SpanReceiver rcvr : this.receivers) {
            Trace.addReceiver(rcvr);
        }
    }

    public synchronized void closeReceivers() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (SpanReceiver rcvr : this.receivers) {
            try {
                rcvr.close();
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to close SpanReceiver correctly: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    @SuppressWarnings(value={"SE_BAD_FIELD"})
    private static enum SingletonHolder {
        INSTANCE;

        Object lock = new Object();
        SpanReceiverHost host = null;
    }
}

