/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.util.Properties;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;

public class DefaultHoodieRecordPayload
extends OverwriteWithLatestAvroPayload {
    public DefaultHoodieRecordPayload(GenericRecord record, Comparable orderingVal) {
        super(record, orderingVal);
    }

    public DefaultHoodieRecordPayload(Option<GenericRecord> record) {
        this(record.isPresent() ? record.get() : null, record1 -> 0);
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord currentValue, Schema schema, Properties properties) throws IOException {
        if (this.recordBytes.length == 0) {
            return Option.empty();
        }
        GenericRecord incomingRecord = HoodieAvroUtils.bytesToAvro(this.recordBytes, schema);
        Object persistedOrderingVal = HoodieAvroUtils.getNestedFieldVal((GenericRecord)currentValue, properties.getProperty("hoodie.payload.ordering.field"), true);
        Comparable incomingOrderingVal = (Comparable)HoodieAvroUtils.getNestedFieldVal(incomingRecord, properties.getProperty("hoodie.payload.ordering.field"), false);
        if (persistedOrderingVal != null && ((Comparable)persistedOrderingVal).compareTo(incomingOrderingVal) > 0) {
            return Option.of(currentValue);
        }
        if (this.isDeleteRecord(incomingRecord)) {
            return Option.empty();
        }
        return Option.of(incomingRecord);
    }
}

