/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;

public class HoodieAvroPayload
implements HoodieRecordPayload<HoodieAvroPayload> {
    private final byte[] recordBytes;

    public HoodieAvroPayload(Option<GenericRecord> record) {
        this.recordBytes = record.isPresent() ? HoodieAvroUtils.avroToBytes(record.get()) : new byte[0];
    }

    @Override
    public HoodieAvroPayload preCombine(HoodieAvroPayload another) {
        return this;
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord currentValue, Schema schema) throws IOException {
        return this.getInsertValue(schema);
    }

    @Override
    public Option<IndexedRecord> getInsertValue(Schema schema) throws IOException {
        if (this.recordBytes.length == 0) {
            return Option.empty();
        }
        return Option.of(HoodieAvroUtils.bytesToAvro(this.recordBytes, schema));
    }

    public byte[] getRecordBytes() {
        return this.recordBytes;
    }
}

